/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class SwingPrintUtility
implements Printable {
    private final Component componentToBePrinted;
    private JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public static void printComponent(Component c) {
        new SwingPrintUtility(c).print();
    }

    public SwingPrintUtility(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                this.logger.error(pe);
                pe.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        SwingPrintUtility.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2d);
        SwingPrintUtility.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }
}

