/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import com.jk.desktop.swing.SwingUtility;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.util.JKCollectionUtil;
import com.jk.util.JKIOUtil;
import java.awt.Color;
import java.io.InputStream;
import java.util.Properties;

public class JKColors {
    private static JKLogger logger = JKLoggerFactory.getLogger(Color.class);
    static Properties prop = new Properties();
    public static final Color DARK_BLUE;
    public static final Color NICE_BLUE;
    public static final Color SKY_BLUE;
    public static final Color MAIN_PANEL_BG;
    public static final Color MODULE_PANEL_BG;
    public static final Color MODULE_BUTTON_BG;
    public static final Color MODULE_BUTTON_FC;
    public static final Color MODULE_SELECTED_FC;
    public static final Color MODULE_SELECTED_BG;
    public static final Color MENU_PANEL_BG;
    public static final Color MENU_BUTTON_BG;
    public static final Color MENU_BUTTON_FC;
    public static final Color MI_PANEL_BG;
    public static final Color MI_BUTTON_BG;
    public static final Color MI_BUTTON_FC;
    public static final Color JK_TITLE_BAR_BG;
    public static final Color JK_TITLE_BAR_FG;
    public static final Color JK_LABEL_BG;
    public static final Color JK_LABEL_FG;
    public static final Color JK_BUTTON_BG;
    public static final Color JK_BUTTON_FG;
    public static final Color JK_TITLE_BG;
    public static final Color JK_TITLE_FG;
    public static final Color TITLE_BORDER_BG;
    public static final Color TABLE_EVEN_ROW;
    public static final Color TABLE_ODD_ROW;
    public static final Color FAVORITE_ITEM_BORDER;
    public static final Color CELL_EDITOR_BG;
    public static final Color CELL_EDTIOR_FG;
    public static final Color JK_STATUS_BAR_BG;
    public static final Color FAVORITE_BG;
    public static final Color JK_STATUS_BAR_FG;
    public static final Color MI_PANEL_TITLE_BG;
    public static final Color MI_PANEL_TITLE_FG;
    public static final Color SPLASH_HEADER_COLOR;

    protected static Color getColor(String colorStr) {
        return JKColors.getColor(colorStr, null);
    }

    private static Color getColor(String colorStr, Color defaultColor) {
        if (prop.getProperty(colorStr = JKCollectionUtil.fixPropertyKey(colorStr)) == null) {
            logger.debug("Color  ", colorStr, " Is not avaiable ");
            return defaultColor;
        }
        String[] color = prop.getProperty(colorStr).split(",");
        String colorHex = color[0];
        if (color.length != 3) {
            return SwingUtility.hexToColor(colorHex);
        }
        return new Color(Integer.parseInt(colorHex), Integer.parseInt(color[1]), Integer.parseInt(color[2]));
    }

    public static void main(String[] args) {
        System.out.println();
    }

    static {
        InputStream inputStream = JKIOUtil.getInputStream("/color.properties");
        if (inputStream != null) {
            prop = JKIOUtil.readPropertiesStream(inputStream);
        } else {
            logger.info("No theme found , default theme will be loaded");
        }
        DARK_BLUE = new Color(22, 125, 219);
        NICE_BLUE = new Color(191, 215, 255);
        SKY_BLUE = new Color(219, 229, 241);
        MAIN_PANEL_BG = JKColors.getColor("main_panel_bg");
        MODULE_PANEL_BG = JKColors.getColor("module_panel_bg");
        MODULE_BUTTON_BG = JKColors.getColor("module_button_bg");
        MODULE_BUTTON_FC = JKColors.getColor("module_button_fc");
        MODULE_SELECTED_FC = JKColors.getColor("module_selected_fc");
        MODULE_SELECTED_BG = JKColors.getColor("module_selected_bg");
        MENU_PANEL_BG = JKColors.getColor("menu_panel_bg");
        MENU_BUTTON_BG = JKColors.getColor("menu_button_bg");
        MENU_BUTTON_FC = JKColors.getColor("menu_button_fc");
        MI_PANEL_BG = JKColors.getColor("mi_panel_bg");
        MI_BUTTON_BG = JKColors.getColor("mi_button_bg");
        MI_BUTTON_FC = JKColors.getColor("mi_button_fc");
        JK_TITLE_BAR_BG = JKColors.getColor("title_bar_bg");
        JK_TITLE_BAR_FG = JKColors.getColor("title_bar_fg");
        JK_LABEL_BG = JKColors.getColor("label_bg");
        JK_LABEL_FG = JKColors.getColor("label_fg");
        JK_BUTTON_BG = JKColors.getColor("button_bg");
        JK_BUTTON_FG = JKColors.getColor("button_fg");
        JK_TITLE_BG = JKColors.getColor("title_bg");
        JK_TITLE_FG = JKColors.getColor("title_fg");
        TITLE_BORDER_BG = JKColors.getColor("title_border_bg");
        TABLE_EVEN_ROW = JKColors.getColor("table_even_row");
        TABLE_ODD_ROW = JKColors.getColor("table_odd_row");
        FAVORITE_ITEM_BORDER = new Color(173, 20, 0);
        CELL_EDITOR_BG = MAIN_PANEL_BG;
        CELL_EDTIOR_FG = Color.black;
        JK_STATUS_BAR_BG = JKColors.getColor("status_bg");
        FAVORITE_BG = JKColors.getColor("favorite_bg");
        JK_STATUS_BAR_FG = JKColors.getColor("status_bg");
        MI_PANEL_TITLE_BG = JKColors.getColor("mi-panel-title-bg");
        MI_PANEL_TITLE_FG = JKColors.getColor("mi-panel-title-fg");
        SPLASH_HEADER_COLOR = JKColors.getColor("splash-header-fg", Color.WHITE);
    }
}

