/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class ImageUtil {
    public static BufferedImage getCompatibleImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        return image;
    }

    public static BufferedImage imageToBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return bi;
    }

    public static BufferedImage loadImage(byte[] imageData) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        BufferedImage bi = ImageIO.read(in);
        in.close();
        return bi;
    }

    public static BufferedImage scaleNewerWay(BufferedImage source, boolean compat, int width, int height) {
        BufferedImage bi = compat ? ImageUtil.getCompatibleImage(width, height) : new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        double xScale = (double)width / (double)source.getWidth();
        double yScale = (double)height / (double)source.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g2d.drawRenderedImage(source, at);
        g2d.dispose();
        return bi;
    }

    public static byte[] toFormat(Image img, String format) throws IOException {
        BufferedImage bi = ImageUtil.imageToBufferedImage(img);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format.toLowerCase());
        if (writers == null || !writers.hasNext()) {
            throw new IllegalArgumentException("Unsupported format (" + format + ")");
        }
        ImageWriter writer = writers.next();
        IIOImage iioImg = new IIOImage(bi, null, null);
        ImageWriteParam iwparam = writer.getDefaultWriteParam();
        if ("jpeg".equalsIgnoreCase(format)) {
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(1.0f);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setOutput(ImageIO.createImageOutputStream(out));
        writer.write(null, iioImg, iwparam);
        return out.toByteArray();
    }

    public static byte[] toJpeg(Image img) throws IOException {
        return ImageUtil.toFormat(img, "jpeg");
    }

    public static byte[] toPng(Image img) throws IOException {
        return ImageUtil.toFormat(img, "png");
    }
}

