/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GraphicsFactory {
    public static Color createGradientColor(Color color) {
        int blue;
        int green;
        int inc = 30;
        int red = color.getRed() + 30;
        Color gredientColor = new Color(red > 255 ? 255 : red, (green = color.getGreen() + 30) > 255 ? 255 : green, (blue = color.getBlue() + 30) > 255 ? 255 : blue);
        if (gredientColor.equals(Color.white)) {
            gredientColor = new Color(color.getRed() - 30, color.getGreen() - 30, color.getBlue() - 30);
        }
        return gredientColor;
    }

    private static Rectangle2D getRectangle(int width, int height) {
        Rectangle2D.Double rec = new Rectangle2D.Double(0.0, 0.0, width, height);
        return rec;
    }

    public static void makeGradient(Component comp, Graphics g, Color fromColor) {
        GraphicsFactory.makeGradient(comp, g, fromColor, GraphicsFactory.createGradientColor(fromColor), GradientType.HORIZENTAL);
    }

    public static void makeGradient(Component comp, Graphics g, Color fromColor, Color toColor, GradientType type) {
        int height = comp.getHeight();
        int width = comp.getWidth();
        int endWidth = 0;
        int endHeight = 0;
        boolean cycle = true;
        if (type == GradientType.HORIZENTAL) {
            endHeight = height / 2;
        } else if (type == GradientType.VERTICAL) {
            endWidth = width / 2;
        } else if (type == GradientType.DIAGNOLE) {
            endWidth = width / 2;
            endHeight = height / 2;
        } else if (type == GradientType.HORIZENTAL_LINEAR) {
            endWidth = width;
            cycle = false;
        } else if (type == GradientType.VERTICAL_LINEAR) {
            endHeight = height;
            cycle = false;
        }
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, fromColor, endWidth, endHeight, toColor, cycle);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gradient);
        g2d.fill(GraphicsFactory.getRectangle(width, height));
    }

    public static enum GradientType {
        VERTICAL,
        HORIZENTAL,
        DIAGNOLE,
        VERTICAL_LINEAR,
        HORIZENTAL_LINEAR;

    }
}

