/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;

public class DialogUtils {
    public static void addEscapeToCloseSupport(final JDialog dialog, final boolean fadeOnClose) {
        LayerUI<Container> layerUI = new LayerUI<Container>(){
            private static final long serialVersionUID = -7197890707453641705L;
            private boolean closing = false;

            @Override
            public void eventDispatched(AWTEvent e, JLayer<? extends Container> l) {
                if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 27) {
                    if (this.closing) {
                        return;
                    }
                    this.closing = true;
                    if (fadeOnClose) {
                        DialogUtils.fadeOut(dialog);
                    } else {
                        dialog.dispose();
                    }
                }
            }

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                ((JLayer)c).setLayerEventMask(8L);
            }

            @Override
            public void uninstallUI(JComponent c) {
                super.uninstallUI(c);
                ((JLayer)c).setLayerEventMask(0L);
            }
        };
        JLayer<Container> layer = new JLayer<Container>(dialog.getContentPane(), layerUI);
        dialog.setContentPane(layer);
    }

    public static void createDialogBackPanel(JDialog dialog, Container parent) {
        DialogBackPanel newContentPane = new DialogBackPanel(dialog);
        dialog.setContentPane(newContentPane);
        dialog.setSize(parent.getSize());
        if (parent != null && parent instanceof JFrame) {
            JFrame frm = (JFrame)parent;
            dialog.setLocation(frm.getContentPane().getLocationOnScreen());
        }
    }

    public static void fadeIn(final JDialog dialog) {
        final Timer timer = new Timer(10, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 0.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity += 0.15f;
                dialog.setOpacity(Math.min(this.opacity, 1.0f));
                if (this.opacity >= 1.0f) {
                    timer.stop();
                }
            }
        });
        dialog.setOpacity(0.0f);
        timer.start();
        dialog.setVisible(true);
    }

    public static void fadeOut(final JDialog dialog) {
        final Timer timer = new Timer(10, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 1.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity -= 0.15f;
                dialog.setOpacity(Math.max(this.opacity, 0.0f));
                if (this.opacity <= 0.0f) {
                    timer.stop();
                    dialog.dispose();
                }
            }
        });
        dialog.setOpacity(1.0f);
        timer.start();
    }

    private static class DialogBackPanel
    extends JPanel {
        private static final long serialVersionUID = 4661510795553055144L;
        private static final Paint fill = new Color(-1426063361, true);
        private static final ImageIcon shadowImage = new ImageIcon(DialogUtils.class.getResource("dialogShadow.png"));
        private final JComponent cmp;
        private final JLabel title = new JLabel();
        private final JLabel info = new JLabel("Hit 'ESC' to close the dialog");

        public DialogBackPanel(JDialog dialog) {
            this.cmp = (JComponent)dialog.getContentPane();
            this.setOpaque(false);
            this.setLayout(null);
            this.add(this.cmp);
            this.add(this.title);
            this.add(this.info);
            this.cmp.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
            this.title.setFont(new Font("SquareFont", 0, 26));
            this.title.setForeground(Color.WHITE);
            this.info.setForeground(Color.WHITE);
            this.title.setText(dialog.getTitle());
            this.title.setSize(this.title.getPreferredSize());
            this.info.setSize(this.info.getPreferredSize());
            this.cmp.setSize(this.cmp.getPreferredSize());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getWidth();
            int h = this.getHeight();
            int shadowX = w / 2 - (this.cmp.getWidth() + 100) / 2;
            int shadowY = h / 2 - (this.cmp.getHeight() + 100) / 2;
            this.cmp.setLocation(w / 2 - this.cmp.getWidth() / 2, h / 2 - this.cmp.getHeight() / 2);
            this.title.setLocation(w / 2 - this.cmp.getWidth() / 2, h / 2 - this.cmp.getHeight() / 2 - this.title.getHeight());
            this.info.setLocation(w / 2 + this.cmp.getWidth() / 2 - this.info.getWidth(), h / 2 - this.cmp.getHeight() / 2 - this.info.getHeight());
            Graphics2D gg = (Graphics2D)g.create();
            gg.setPaint(fill);
            gg.fillRect(0, 0, w, h);
            gg.drawImage(shadowImage.getImage(), shadowX, shadowY, this.cmp.getWidth() + 100, this.cmp.getHeight() + 100, null);
            gg.dispose();
        }
    }
}

