/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.tree;

import com.jk.desktop.swing.tree.TreeCheckBoxNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class TreeCheckBoxNodeRenderer
implements TreeCellRenderer {
    private final JCheckBox leafRenderer = new JCheckBox("");
    Color selectionBorderColor;
    Color selectionForeground;
    Color selectionBackground;
    Color textForeground;
    Color textBackground;

    public TreeCheckBoxNodeRenderer() {
        Boolean booleanValue;
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.leafRenderer.setFont(fontValue);
        }
        this.leafRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    protected JCheckBox getLeafRenderer() {
        return this.leafRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, false);
        this.leafRenderer.setText(stringValue);
        this.leafRenderer.setSelected(false);
        this.leafRenderer.setEnabled(tree.isEnabled());
        this.leafRenderer.setForeground(this.textForeground);
        this.leafRenderer.setBackground(this.textBackground);
        if (value instanceof TreeCheckBoxNode) {
            TreeCheckBoxNode node = (TreeCheckBoxNode)value;
            this.leafRenderer.setText(node.getText());
            this.leafRenderer.setSelected(node.isSelected());
        }
        JCheckBox returnValue = this.leafRenderer;
        return returnValue;
    }
}

