/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.tree;

import com.jk.desktop.swing.comp.JKTree;
import com.jk.desktop.swing.tree.TreeCheckBoxNode;
import com.jk.desktop.swing.tree.TreeCheckBoxNodeRenderer;
import com.jk.desktop.util.TreeUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;

public class TreeCheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = 5144761768239460062L;
    Vector<CellEditorListener> listeners = new Vector();
    TreeCheckBoxNodeRenderer renderer = new TreeCheckBoxNodeRenderer();
    JKTree tree;
    private TreeCheckBoxNode checkBoxNode;
    private final JCheckBox checkBox;
    boolean editing;

    public TreeCheckBoxNodeEditor(JKTree tree) {
        this.tree = tree;
        this.checkBox = this.renderer.getLeafRenderer();
        this.checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreeCheckBoxNodeEditor.this.handleCheckBoxValueChanged(TreeCheckBoxNodeEditor.this.checkBox);
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (this.checkBoxNode != null) {
            this.checkBoxNode.setSelected(this.checkBox.isSelected());
            TreeUtil.setSelected(this.tree, this.checkBoxNode, this.checkBox.isSelected(), true);
            TreeUtil.setParentSelected(this.tree, this.checkBoxNode, this.checkBox.isSelected());
            this.tree.refresh();
        }
        return this.checkBoxNode;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        this.checkBoxNode = value instanceof TreeCheckBoxNode ? (TreeCheckBoxNode)value : null;
        return editor;
    }

    private void handleCheckBoxValueChanged(JCheckBox checkBox) {
        this.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return true;
    }
}

