/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.text.documents;

import com.jk.util.JKConversionUtil;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_LENGTH = 10;
    long max;

    public NumberDocument() {
        this(Long.MAX_VALUE);
    }

    public NumberDocument(long maxLength) {
        this.max = maxLength;
    }

    @Override
    public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
        if (this.isNumeric(s) && (long)this.getContent().length() <= this.max) {
            super.insertString(i, JKConversionUtil.toInteger(s).toString(), attributeset);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean isNumeric(String s) {
        try {
            Double.valueOf(s);
        }
        catch (NumberFormatException numberformatexception) {
            return false;
        }
        return true;
    }
}

