/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.text.documents;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private final int maxLen;

    public FloatDocument() {
        this(10);
    }

    public FloatDocument(int maxLen) {
        this.maxLen = maxLen;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        block6: {
            if (this.getContent().length() <= this.maxLen) {
                String tmpText = this.getText(0, offs) + str;
                if (offs < this.getLength()) {
                    tmpText = tmpText + this.getText(offs, this.getLength());
                }
                tmpText = tmpText.trim();
                try {
                    Float.parseFloat(tmpText);
                    super.insertString(offs, str.trim(), a);
                }
                catch (NumberFormatException e) {
                    if (offs == 0 && tmpText.equals("-")) {
                        super.insertString(offs, str.trim(), a);
                    }
                }
                catch (Throwable t) {
                    if (str == null || str.length() == 0) break block6;
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

