/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.dialogs;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKLabel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.dialogs.JKDialog;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JKProgressDialog
extends JKDialog {
    private static final long serialVersionUID = 1L;
    private final Vector<Runnable> tasks = new Vector();
    private JKLabel messageLabel = null;
    private final JKButton closeButton = new JKButton("Cancel");
    private Component closePanel = null;
    private JProgressBar progressBar = null;
    private String completionMessage = null;
    private final boolean cancelled = false;
    private String closeText = "Close";
    private boolean conteniueProcessing;

    public static JKProgressDialog create(Object parent, String title, String message, boolean modal) {
        if (parent instanceof Frame) {
            return new JKProgressDialog((Frame)parent, title, message, modal);
        }
        if (parent instanceof Dialog) {
            return new JKProgressDialog((Dialog)parent, title, message, modal);
        }
        return null;
    }

    public static JKProgressDialog create(String title, String message) {
        return JKProgressDialog.create(SwingUtility.getDefaultMainFrame(), title, message, false);
    }

    public static JKProgressDialog create(String title, String message, boolean modal) {
        return JKProgressDialog.create(SwingUtility.getDefaultMainFrame(), title, message, modal);
    }

    public JKProgressDialog(Dialog parent, String title, String message) {
        super((Window)parent, title);
        this.init(parent, message, false);
    }

    public JKProgressDialog(Dialog parent, String title, String message, boolean modal) {
        super((Window)parent, title);
        this.init(parent, message, modal);
    }

    public JKProgressDialog(Frame parent, String title, String message) {
        super(parent, title);
        this.init(parent, message, false);
    }

    public JKProgressDialog(Frame parent, String title, String message, boolean modal) {
        super(parent, title);
        this.init(parent, message, modal);
    }

    public void addTask(Runnable r) {
        this.tasks.add(r);
    }

    private Component borderComponent(Component comp) {
        Box horizBox = Box.createHorizontalBox();
        horizBox.add(Box.createHorizontalGlue());
        horizBox.add(comp);
        horizBox.add(Box.createHorizontalGlue());
        Box vertBox = Box.createVerticalBox();
        vertBox.add(Box.createVerticalStrut(5));
        vertBox.add(horizBox);
        vertBox.add(Box.createVerticalStrut(5));
        return vertBox;
    }

    public void finished() {
        this.tasks.clear();
        if (this.completionMessage == null) {
            this.dispose();
        } else {
            this.messageLabel.setText(this.completionMessage);
            this.getContentPane().remove(this.progressBar);
            this.closeButton.setText(this.closeText);
            this.closePanel.setVisible(true);
            this.setDefaultCloseOperation(2);
            this.invalidate();
            this.pack();
        }
    }

    private void handleClose() {
        this.dispose();
        throw new RuntimeException("Progress bar has been interuupred by user");
    }

    private void init(Component parent, String message, boolean modal) {
        this.setModal(modal);
        this.setPreferredSize(new Dimension(300, 120));
        this.setDefaultCloseOperation(0);
        if (message == null) {
            message = JKMessage.get("PLEASE_WAIT", new Object[0]);
        }
        this.messageLabel = new JKLabel(message);
        JKLabel iconLabel = new JKLabel("");
        iconLabel.setIcon("progress.gif");
        JKPanel pnl = new JKPanel(new GridLayout(2, 1));
        pnl.add(this.messageLabel);
        pnl.add(iconLabel);
        this.progressBar = new JProgressBar();
        this.getContentPane().add(pnl, "North");
        this.getContentPane().add((Component)this.progressBar, "Center");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKProgressDialog.this.handleClose();
            }
        });
        this.closePanel = this.borderComponent(this.closeButton);
        this.closePanel.setVisible(false);
        this.getContentPane().add(this.closePanel, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JKProgressDialog.this.conteniueProcessing = false;
            }
        });
    }

    public boolean isConteniueProcessing() {
        return this.conteniueProcessing;
    }

    public void run() {
        this.conteniueProcessing = true;
        this.progressBar.setMaximum(this.tasks.size() * 100);
        WorkThread w = new WorkThread();
        w.start();
        this.setVisible(true);
    }

    public void setCancellable(boolean canCancel) {
        this.closePanel.setVisible(canCancel);
        this.pack();
    }

    public void setCancelText(String text) {
        this.closeButton.setText(text);
    }

    public void setCloseText(String text) {
        this.closeText = text;
    }

    public void setCompletionMessage(String msg) {
        this.completionMessage = msg;
    }

    public void setProgressCount(String string) {
        this.messageLabel.setText(string);
        this.pack();
    }

    private class WorkThread
    extends Thread
    implements ChangeListener {
        private Runnable task;
        private int i;

        private WorkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.i = 0;
            while (this.i < JKProgressDialog.this.tasks.size()) {
                try {
                    this.task = (Runnable)JKProgressDialog.this.tasks.get(this.i);
                    if (this.task instanceof Task) {
                        String msg = ((Task)this.task).getMessage();
                        JKProgressDialog.this.progressBar.setString(msg);
                        JKProgressDialog.this.progressBar.setStringPainted(msg != null);
                        ((Task)this.task).addChangeListener(this);
                    }
                    this.task.run();
                }
                catch (Throwable t) {
                    JKExceptionUtil.handle(t);
                }
                finally {
                    JKProgressDialog.this.conteniueProcessing = false;
                    JKProgressDialog.this.finished();
                }
                JKProgressDialog.this.progressBar.setValue(++this.i * 100);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                int percent = ((Task)this.task).getPercentComplete() % 100;
                JKProgressDialog.this.progressBar.setValue(this.i * 100 + percent);
                String msg = ((Task)this.task).getMessage();
                JKProgressDialog.this.progressBar.setStringPainted(msg != null);
                JKProgressDialog.this.progressBar.setString(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Task
    extends Runnable {
        public void addChangeListener(ChangeListener var1);

        public String getMessage();

        public int getPercentComplete();
    }

    public class CancelledException
    extends Error {
        private static final long serialVersionUID = 1L;
    }

    public static interface CancellableTask
    extends Task {
    }
}

