/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.dialogs;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.SwingValidator;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKLabledComponent;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.text.documents.FloatDocument;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class JKDlgInput
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    final JKTextField txtValue = new JKTextField(new FloatDocument(5), 20);
    JKButton btnOk = new JKButton("OK");
    JKButton btnCancel = new JKButton("CANCEL");
    private Float amount;
    private final String title;
    private final Float rangeTo;
    private final Float rangeFrom;

    public static void main(String[] args) {
        JKDlgInput.showInputDialog("Fees");
    }

    public static Float showInputDialog(String title) {
        return JKDlgInput.showInputDialog(title, "");
    }

    public static Float showInputDialog(String title, String defaultValue) {
        return Float.valueOf(JKDlgInput.showInputDialog(title, defaultValue, null, null));
    }

    public static float showInputDialog(String title, String defaultValue, Float rangeFrom, Float rangeTo) {
        JKDlgInput pnl = new JKDlgInput(defaultValue, title, rangeFrom, rangeTo);
        SwingUtility.showPanelInDialog(pnl, "INPUT_DIALOG");
        return pnl.amount.floatValue();
    }

    private JKDlgInput(String defaultValue, String title, Float rangeFrom, Float rangeTo) {
        this.title = title;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
        this.init();
        this.txtValue.setText(defaultValue);
    }

    protected void handleOk() {
        SwingValidator.checkEmpty(this.txtValue);
        if (this.rangeFrom != null && this.rangeTo != null) {
            SwingValidator.checkValidRange(this.txtValue, this.rangeFrom.floatValue(), this.rangeTo.floatValue());
        }
        this.amount = Float.valueOf(this.txtValue.getTextAsFloat());
        SwingUtility.closePanelDialog(this);
    }

    void init() {
        this.setLayout(new BorderLayout());
        JKPanel pnlInfo = new JKPanel();
        pnlInfo.setBorder(SwingUtility.createTitledBorder("SET_VALUE"));
        pnlInfo.add(new JKLabledComponent(this.title, (BindingComponent)this.txtValue));
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.add(this.btnOk);
        pnlButtons.add(this.btnCancel);
        this.add(pnlInfo, "Center");
        this.add(pnlButtons, "South");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKDlgInput.this.handleOk();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKDlgInput.this.amount = null;
                SwingUtility.closePanelDialog(JKDlgInput.this);
            }
        });
        this.txtValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    JKDlgInput.this.btnOk.doClick();
                }
            }
        });
    }
}

