/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.renderers;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKTable;
import com.jk.desktop.util.JKColors;
import com.jk.util.JKFormatUtil;
import com.jk.util.model.table.JKTableModel;
import java.awt.Color;
import java.awt.Component;
import java.sql.Time;
import java.text.Format;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class JKDefaultTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3671580631267035219L;
    private static final Color SELECTED_ROW_COLOR = new Color(150, 150, 255);
    private static final Color ODD_ROW_COLOR = new Color(255, 255, 255);
    private static final Color EVEN_ROW_COLOR = JKColors.TABLE_EVEN_ROW;
    private Format format;

    public Format getFormat() {
        return this.format;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Format format;
        this.setComponentOrientation(table.getComponentOrientation());
        if (table instanceof JKTable) {
            JKTable tbl = (JKTable)table;
        }
        if ((format = this.format) == null && table.getModel() instanceof JKTableModel) {
            JKTableModel model = (JKTableModel)table.getModel();
            format = model.getFormatter(column);
        }
        if (format != null && value != null) {
            try {
                value = format.format(value);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to format col:" + column + " with value :" + value + "  with class:" + value.getClass().getName() + "  with formatter : " + format.getClass().getName());
            }
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            this.setBackground(row % 2 == 0 ? EVEN_ROW_COLOR : ODD_ROW_COLOR);
        } else {
            this.setBackground(SELECTED_ROW_COLOR);
        }
        Class<?> columnClass = table.getModel().getColumnClass(column);
        if (Time.class.isAssignableFrom(columnClass) && value instanceof Time) {
            Time value2 = (Time)value;
            this.setText(JKFormatUtil.formatTime(value2));
        } else if (Date.class.isAssignableFrom(columnClass) && value instanceof Date) {
            Date value2 = (Date)value;
            this.setText(JKFormatUtil.formatDate(value2));
        }
        this.setBorder(SwingUtility.getDefaultEmptyBorder());
        return this;
    }

    public void setFormat(Format format) {
        this.format = format;
    }
}

