/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.renderers;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.util.JKColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class JKBindingComponentEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = -885818003283810185L;
    private final BindingComponent component;
    private JTable table;

    public JKBindingComponentEditor(final BindingComponent component) {
        this.component = component;
        component.setAutoTransferFocus(false);
        this.component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JKBindingComponentEditor.this.stopCellEditing();
            }
        });
        component.addValueChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(Object oldValue, final Object newValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JKBindingComponentEditor.this.table != null && newValue != component.getValue()) {
                            int col = JKBindingComponentEditor.this.table.getSelectedColumn();
                            int row = JKBindingComponentEditor.this.table.getSelectedRow();
                            if (col != -1 && row != -1) {
                                JKBindingComponentEditor.this.table.setValueAt(newValue, row, col);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean equals(Object obj) {
        return obj == this.component;
    }

    @Override
    public Object getCellEditorValue() {
        Object value = this.component.getValue();
        return value;
    }

    public BindingComponent getComponent() {
        return this.component;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.component.setValue(value);
        if (this.component instanceof JKTextField) {
            JKTextField txt = (JKTextField)this.component;
            txt.setType(table.getColumnClass(column));
            txt.setHorizontalAlignment(10);
            txt.selectAll();
        }
        if (isSelected && table.getSelectedColumn() == column) {
            this.component.setBorder(BorderFactory.createLineBorder(Color.blue));
        } else {
            this.component.setBorder(BorderFactory.createLineBorder(JKColors.MAIN_PANEL_BG));
        }
        return (Component)((Object)this.component);
    }

    public void setValue(Object value) {
        this.component.setValue(value);
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }
}

