/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKFrame;
import com.jk.desktop.swing.comp.JKLabel;
import com.jk.desktop.swing.comp.panels.JKMainPanel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.comp.panels.JKTitleButton;
import com.jk.desktop.util.GraphicsFactory;
import com.jk.desktop.util.JKColors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class JKTitledPanel
extends JKMainPanel {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String icon;
    protected JKPanel panel;
    JKMainPanel pnlTitleBar = new JKMainPanel(new GridLayout(1, 2, 2, 2));
    JKPanel<?> pnlTitle = new JKPanel(new FlowLayout(3));
    JKPanel<?> pnlButtons = new JKPanel(new FlowLayout(4));
    JKButton btnAddToFavorites = new JKTitleButton("");
    JKButton btnShowInFrame = new JKTitleButton("");
    JKButton btnReload = new JKTitleButton("");
    JKButton btnClose = new JKTitleButton("");
    JKButton btnNext = new JKTitleButton(">");
    JKButton btnPrevious = new JKTitleButton("<");
    JKLabel lbl;

    public JKTitledPanel(String title, JKPanel panel) {
        this(title, panel, null);
    }

    public JKTitledPanel(String title, JKPanel panel, String icon) {
        this.title = title;
        this.panel = panel;
        this.icon = icon;
        this.init();
        this.showPanel();
    }

    private JKPanel<?> getTitleBar() {
        this.initComponenets();
        this.pnlTitleBar.setGradientType(GraphicsFactory.GradientType.HORIZENTAL);
        this.btnClose.setShortcut("control X", "");
        this.btnReload.setShortcut("control R", "");
        this.pnlTitle.add(this.lbl);
        this.pnlButtons.add(this.btnAddToFavorites);
        this.pnlButtons.add(this.btnShowInFrame);
        this.pnlButtons.add(this.btnReload);
        this.pnlButtons.add(this.btnPrevious);
        this.pnlButtons.add(this.btnNext);
        this.pnlButtons.add(this.btnClose);
        this.pnlTitleBar.add(this.pnlTitle);
        this.pnlTitleBar.add(this.pnlButtons);
        this.btnAddToFavorites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKTitledPanel.this.handleAddToFavorites();
            }
        });
        this.btnShowInFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKTitledPanel.this.handleShowInFrame();
            }
        });
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKTitledPanel.this.handleReload();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtility.getDefaultMainFrame().showHomePanel();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKTitledPanel.this.handleNext();
            }
        });
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKTitledPanel.this.handlePreviouse();
            }
        });
        return this.pnlTitleBar;
    }

    protected void handleAddToFavorites() {
    }

    protected void handleNext() {
    }

    protected void handlePreviouse() {
    }

    protected void handleReload() {
    }

    protected void handleShowInFrame() {
        JKFrame frame = SwingUtility.showPanelFrame(this, this.title);
        frame.setExtendedState(0);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JKPanel<?> titleBar = this.getTitleBar();
        this.add(titleBar, "North");
        this.applyComponentOrientation(SwingUtility.getDefaultComponentOrientation());
    }

    private void initComponenets() {
        this.pnlTitleBar.setBackground(JKColors.JK_TITLE_BAR_BG);
        this.pnlTitleBar.setPreferredSize(new Dimension(800, 35));
        this.lbl = new JKLabel();
        this.lbl.setCaptilize(true);
        this.lbl.setText(this.title);
        this.lbl.setOpaque(false);
        this.lbl.setForeground(JKColors.JK_TITLE_BAR_FG);
        this.lbl.setPreferredSize(null);
        this.lbl.setFont(SwingUtility.getDefaultTitleFont());
        this.lbl.setVerticalAlignment(1);
        if (this.icon != null) {
            this.lbl.setIcon(this.icon);
        }
        this.pnlTitle.setOpaque(false);
        this.btnShowInFrame.setToolTipText("POP_OUT_WINDOW");
        this.btnReload.setIcon("small_reload_2.png");
        this.btnClose.setIcon("smal_close.png");
        this.btnAddToFavorites.setIcon("1463807492_keditbookmarks.png");
        this.btnShowInFrame.setIcon("show_courses.png");
        this.btnClose.setToolTipText("CLOSE_PANEL");
        this.btnReload.setToolTipText("RELOAD");
        this.btnClose.setToolTipText("CLOSE");
        this.btnAddToFavorites.setToolTipText("ADD_TO_FAVORITES");
        this.btnNext.setToolTipText("NEXT_WINDOW");
        this.btnPrevious.setToolTipText("PREVIOUSE_WINDOW");
    }

    protected void showPanel() {
        this.add((Component)this.panel, "Center");
        this.validate();
        this.repaint();
    }
}

