/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.JKErrorLabel;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.util.GraphicsFactory;
import com.jk.desktop.validation.exception.UIValidationException;
import com.jk.locale.JKMessage;
import com.jk.validation.Validator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JKPanel<T>
extends JPanel
implements BindingComponent<T> {
    private static final long serialVersionUID = 1L;
    private GraphicsFactory.GradientType gradientType;
    private Color gredientColor;
    private Image backGroundImage;
    protected FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean transfer;

    public JKPanel() {
        this.initJKPanel();
    }

    public JKPanel(GraphicsFactory.GradientType gradientType) {
        this.gradientType = gradientType;
    }

    public JKPanel(JComponent component) {
        this();
        this.add(component);
    }

    public JKPanel(JComponent container, String title) {
        this(container);
        this.setTitle(title);
    }

    public JKPanel(LayoutManager layout) {
        super(layout);
        this.initJKPanel();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void addValidator(Validator validator) {
        this.fsWrapper.addValidator(validator);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.fsWrapper.addValueChangeListsner(listener);
    }

    @Override
    public void clear() {
        String methodName = "clear ";
        this.handleUnAllowedMethodCall("clear ");
    }

    @Override
    public void filterValues(BindingComponent component) {
    }

    public Image getBackGroundImage() {
        return this.backGroundImage;
    }

    @Override
    public T getDefaultValue() {
        String methodName = "getDefaultValue ";
        return this.handleUnAllowedMethodCall("getDefaultValue ");
    }

    public GraphicsFactory.GradientType getGradientType() {
        return this.gradientType;
    }

    @Override
    public T getValue() {
        String methodName = "getValue ";
        return this.handleUnAllowedMethodCall("getValue ");
    }

    private T handleUnAllowedMethodCall(String methodName) {
        return null;
    }

    private void initJKPanel() {
        this.setOpaque(false);
        this.setLocale(SwingUtility.getDefaultLocale());
        this.setFocusable(false);
        this.setBackground(SwingUtility.getDefaultBackgroundColor());
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 3) {
                    JKPanel.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.backGroundImage == null) {
            super.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            double mw = this.backGroundImage.getWidth(null);
            double mh = this.backGroundImage.getHeight(null);
            double sw = (double)this.getWidth() / mw;
            double sh = (double)this.getHeight() / mh;
            g2d.scale(sw, sh);
            g2d.drawImage(this.backGroundImage, 0, 0, this);
        }
    }

    public void refreshComponents() {
        this.validate();
        this.repaint();
    }

    @Override
    public void requestFocus() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JKPanel.this.transferFocus();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void reset() {
        String methodName = "reset ";
        this.handleUnAllowedMethodCall("reset ");
    }

    public void resetComponents() {
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public void setBackGroundImage(Image backGroundImage) {
        this.backGroundImage = backGroundImage;
    }

    public void setBackGroundImage(String imageName) {
        this.setBackGroundImage(SwingUtility.getImage(imageName));
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof TitledBorder) {
            TitledBorder b = (TitledBorder)border;
            b.setTitle(JKMessage.get(b.getTitle(), true));
        }
        super.setBorder(border);
    }

    @Override
    public void setDefaultValue(T t) {
        String methodName = "setDefaultValue ";
        this.handleUnAllowedMethodCall("setDefaultValue ");
    }

    @Override
    public void setEnabled(boolean enabled) {
        SwingUtility.enableContainer(this, enabled);
    }

    public void setGradientType(GraphicsFactory.GradientType gradientType) {
        this.gradientType = gradientType;
    }

    public void setGredientColor(Color gredientColor) {
        this.gredientColor = gredientColor;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr instanceof FlowLayout) {
            FlowLayout flowLayout = (FlowLayout)mgr;
        }
        super.setLayout(mgr);
    }

    public void setPreferredSize(int width, int height) {
        super.setPreferredSize(new Dimension(width, height));
    }

    public void setTitle(String title) {
        this.setBorder(SwingUtility.createTitledBorder(title));
    }

    @Override
    public void setValue(T value) {
        String methodName = "setValue ";
        this.handleUnAllowedMethodCall("setValue ");
    }

    @Override
    public void validateValue() {
        this.fsWrapper.validateValue();
    }

    public void validateValues() {
        this.validateValues(null);
    }

    public void validateValues(JKErrorLabel fslblErrorl) {
        StringBuffer buf = new StringBuffer();
        Vector<BindingComponent> components = SwingUtility.findBindingComponents(this);
        for (BindingComponent bindingComponent : components) {
            try {
                bindingComponent.validateValue();
            }
            catch (UIValidationException e) {
                if (e.getProblems() != null && fslblErrorl != null) {
                    fslblErrorl.setText(e.getProblems().getLeadProblem().getMessage());
                }
                throw e;
            }
        }
        if (fslblErrorl != null) {
            fslblErrorl.setText("");
        }
    }
}

