/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.util.JKColors;
import com.jk.exceptions.handler.JKExceptionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class JKImagePanel
extends JKPanel {
    private static final long serialVersionUID = 1L;
    public static final int TILED = 0;
    public static final int SCALED = 1;
    public static final int ACTUAL = 2;
    private BufferedImage image;
    private int style;
    private float alignmentX = 0.5f;

    public JKImagePanel() {
    }

    public JKImagePanel(BufferedImage image) {
        this(image, 0);
    }

    public JKImagePanel(BufferedImage image, int style) {
        this.image = image;
        this.style = style;
        this.setLayout(new BorderLayout());
        this.setBackground(JKColors.MAIN_PANEL_BG);
    }

    public void add(JComponent component) {
        this.add(component, null);
    }

    public void add(JComponent component, Object constraints) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
        super.add((Component)component, constraints);
    }

    private void drawActual(Graphics g) {
        Dimension d = this.getSize();
        float x = (float)(d.width - this.image.getWidth()) * this.alignmentX;
        float y = 0.0f;
        g.drawImage(this.image, (int)x, 0, this);
    }

    private void drawTiled(Graphics g) {
        Dimension d = this.getSize();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        for (int x = 0; x < d.width; x += width) {
            for (int y = 0; y < d.height; y += height) {
                g.drawImage(this.image, x, y, null, null);
            }
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                this.drawTiled(g);
                break;
            }
            case 1: {
                Dimension d = this.getSize();
                g.drawImage(this.image, 0, 0, d.width, d.height, null);
                break;
            }
            case 2: {
                this.drawActual(g);
            }
        }
    }

    public void removeImage() {
        this.image = null;
        this.invalidate();
        this.repaint();
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.invalidate();
        this.repaint();
    }

    public void setImage(byte[] image) {
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(image));
            this.invalidate();
            this.repaint();
        }
        catch (IOException e) {
            JKExceptionUtil.handle(e);
        }
    }

    public void setImage(ImageIcon image) {
        this.setImage(new BufferedImage(image.getIconWidth(), image.getIconHeight(), 1));
    }

    public void setImageAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
    }

    public void setImageAlignmentY(float alignmentY) {
    }

    public void setSizeToFitImage() {
        this.setPreferredSize(this.image.getWidth(), this.image.getHeight());
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

