/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKPanel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JKFilePanel
extends JKPanel {
    private static final long serialVersionUID = -5117822786775377237L;
    private final JKTextField txtFilePath = new JKTextField(20);
    private final JFileChooser fileChooser = new JFileChooser(".");
    private final JKButton btnOpenFileChooser = new JKButton("BROWSE");

    public JKFilePanel() {
        this.init();
    }

    public void checkFields() {
        this.txtFilePath.checkEmpty();
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    private void handleOpenFileChooser() {
        int showOpenDialog = this.fileChooser.showOpenDialog(this);
        if (showOpenDialog == 0) {
            this.txtFilePath.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected void init() {
        this.txtFilePath.setEditable(false);
        this.setLayout(new GridLayout(1, 2));
        this.add(this.txtFilePath);
        this.add(this.btnOpenFileChooser);
        this.setPreferredSize(400, 35);
        this.btnOpenFileChooser.setIcon("browse_3.png");
        this.btnOpenFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JKFilePanel.this.handleOpenFileChooser();
            }
        });
    }

    public void setExtensions(String ... extensions) {
        this.fileChooser.setFileFilter(new ExtensionFileFilter(null, extensions));
    }

    class ExtensionFileFilter
    extends FileFilter {
        String description;
        String[] extensions;

        public ExtensionFileFilter(String extension) {
            this(null, extension.split(","));
        }

        public ExtensionFileFilter(String description, String extension) {
            this(description, extension.split(","));
        }

        public ExtensionFileFilter(String description, String[] extensions) {
            if (description == null) {
                this.description = "";
                for (String extension : extensions) {
                    this.description = this.description + extension + ",";
                }
                this.description = this.description.substring(0, this.description.length() - 1);
            } else {
                this.description = description;
            }
            this.extensions = (String[])extensions.clone();
            this.toLower(this.extensions);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String path = file.getAbsolutePath().toLowerCase();
            for (String extension : this.extensions) {
                if (!path.endsWith(extension) || path.charAt(path.length() - extension.length() - 1) != '.') continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private void toLower(String[] array) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = array[i].toLowerCase();
            }
        }
    }
}

