/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.util.JKColors;
import com.jk.exceptions.handler.JKExceptionUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class JKDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = -6686336167205700395L;
    private Image backGroundImage;

    public JKDesktopPane() {
        this.init();
    }

    @Override
    public Component add(Component comp) {
        Component added = super.add(comp);
        if (comp instanceof JInternalFrame) {
            this.setPosition((JInternalFrame)comp);
        }
        return added;
    }

    private void init() {
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.setBackground(JKColors.MAIN_PANEL_BG);
        this.setOpaque(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.backGroundImage == null) {
            super.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            double mw = this.backGroundImage.getWidth(null);
            double mh = this.backGroundImage.getHeight(null);
            double sw = (double)this.getWidth() / mw;
            double sh = (double)this.getHeight() / mh;
            g2d.scale(sw, sh);
            g2d.drawImage(this.backGroundImage, 0, 0, this);
        }
    }

    public void setBackGroundImage(String path) {
        try {
            this.backGroundImage = SwingUtility.getImage(path);
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }

    private void setPosition(JInternalFrame frame) {
        Point location = frame.getLocation();
        if (location.getX() == 0.0 && location.getY() == 0.0) {
            int x;
            int length = this.getAllFrames().length;
            int y = length * 20;
            if (SwingUtility.isLeftOrientation()) {
                x = length * 20;
            } else {
                int width = frame.getContentPane().getPreferredSize().width;
                x = (int)(this.getSize().getWidth() - (double)(length * 20)) - width;
            }
            System.out.println("X=" + x);
            System.out.println("Y=" + y);
            System.out.println(frame.getContentPane().getPreferredSize());
            frame.setLocation(x, y);
        }
    }
}

