/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp.panels;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKLabel;
import com.jk.desktop.swing.comp.panels.JKImagePanel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.dialogs.JKDialog;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import com.jk.util.JKIOUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

public class JKBlobPanel
extends JKPanel
implements BindingComponent {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 262144;
    static JFileChooser ch = SwingUtility.getFileChooser();
    JKButton btnShowPanel = new JKButton("ADD_IMAGE");
    JKButton btnRemoveImage = new JKButton("REMOVE_IMAGE");
    JKImagePanel lblThumb = new JKImagePanel();
    JKPanel pnlBlob = new JKPanel();
    JKLabel lblImage = new JKLabel();
    JKButton btnBrowse = new JKButton("BROWSE");
    JKButton btnScan = new JKButton("FROM_IMAGING_DEVICE");
    JKButton btnClose = new JKButton("CLOSE");
    byte[] object;
    private String fieldName;
    private Object defaultValue;

    public JKBlobPanel() {
    }

    public JKBlobPanel(String field) {
        this.fieldName = field;
        this.init();
    }

    @Override
    public void clear() {
        this.setValue((Object)null);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private JKDialog getDialog() {
        Container cont;
        if (this.pnlBlob.getRootPane() != null && (cont = this.pnlBlob.getRootPane().getParent()) instanceof JKDialog) {
            return (JKDialog)cont;
        }
        return null;
    }

    public String getFileName() {
        return null;
    }

    public Object getValue() {
        return this.object;
    }

    private void handleBrowse() {
        File file;
        if (ch.showOpenDialog(this) == 0 && (file = ch.getSelectedFile()) != null) {
            if (!file.exists()) {
                SwingUtility.showUserErrorDialog("PLEASE_SELECT_VALID_FILE");
            }
            try {
                this.object = JKIOUtil.readStream(new FileInputStream(file));
                this.setValue(this.object);
            }
            catch (IOException e1) {
                JKExceptionUtil.handle(e1);
            }
        }
    }

    private void handleScan() {
    }

    private void init() {
        this.setLayout(new GridLayout(1, 3));
        this.btnShowPanel.setIcon("edit_picture.png");
        this.add(this.lblThumb);
        this.add(this.btnShowPanel);
        this.add(this.btnRemoveImage);
        this.btnRemoveImage.setVisible(false);
        this.lblThumb.setVisible(false);
        this.lblThumb.setPreferredSize(new Dimension(80, 80));
        this.lblThumb.setStyle(1);
        this.btnRemoveImage.setIcon("button_cancel_1.png");
        this.initBlobUploadPanel();
        this.btnShowPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtility.showPanelInDialog(JKBlobPanel.this.pnlBlob, JKBlobPanel.this.fieldName);
            }
        });
        this.btnRemoveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKBlobPanel.this.setValue((Object)null);
            }
        });
    }

    private void initBlobUploadPanel() {
        this.pnlBlob.setPreferredSize(new Dimension(600, 400));
        this.pnlBlob.setLayout(new BorderLayout());
        this.pnlBlob.setMaximumSize(new Dimension(300, 400));
        JKPanel pnlButton = new JKPanel();
        this.btnScan.setIcon("scanner.png");
        this.btnBrowse.setIcon("fileopen.png");
        this.btnClose.setIcon("fileclose.png");
        pnlButton.add(this.btnScan);
        pnlButton.add(this.btnBrowse);
        pnlButton.add(this.btnClose);
        this.pnlBlob.add((Component)new JScrollPane(this.lblImage), "Center");
        this.pnlBlob.add(pnlButton, "South");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKBlobPanel.this.handleBrowse();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKBlobPanel.this.getDialog().dispose();
            }
        });
        this.btnScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JKBlobPanel.this.handleScan();
            }
        });
    }

    @Override
    public void reset() {
        this.setValue((Object)null);
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnShowPanel.setVisible(enabled);
    }

    public void setValue(Object value) {
        if (value != null && value instanceof byte[] && ((byte[])value).length > 0) {
            byte[] val = (byte[])value;
            if (val.length > 262144) {
                SwingUtility.showUserErrorDialog(JKMessage.get("ERROR_INVALID_IMAGE_SIZE", new Object[0]) + " " + val.length);
                return;
            }
            this.object = val;
            ImageIcon image = new ImageIcon(this.object);
            this.lblImage.setIcon(image);
            this.btnShowPanel.setText(JKMessage.get("SHOW", new Object[0]));
            this.btnRemoveImage.setVisible(this.isEnabled());
            this.lblThumb.setVisible(true);
            this.lblThumb.setImage(val);
        } else {
            this.object = null;
            this.lblImage.removeIcon();
            this.lblThumb.removeImage();
            this.invalidate();
            this.repaint();
            this.btnRemoveImage.setVisible(false);
            this.btnShowPanel.setText(JKMessage.get("ADD_IMAGE", new Object[0]));
            this.lblThumb.setVisible(false);
        }
    }
}

