/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKTable;
import com.jk.desktop.util.JKColors;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class TableRenderers {
    static Border gap = BorderFactory.createEmptyBorder(3, 3, 3, 3);

    public static class CustomDataRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Color evenRowColor = JKColors.TABLE_EVEN_ROW;
        Color oddRowColor = JKColors.TABLE_ODD_ROW;

        public CustomDataRenderer() {
            this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        }

        @Override
        public Component getTableCellRendererComponent(JTable jt, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JKTable table;
            Component comp = super.getTableCellRendererComponent(jt, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)comp;
            if (!isSelected) {
                label.setBackground(row % 2 == 0 ? this.evenRowColor : this.oddRowColor);
                label.setForeground(Color.black);
            }
            if ((table = (JKTable)jt).isEditable()) {
                if (table.isEditable(column)) {
                    this.setBackground(JKColors.CELL_EDITOR_BG);
                    this.setForeground(JKColors.CELL_EDTIOR_FG);
                    this.setBorder(BorderFactory.createLoweredBevelBorder());
                    if (hasFocus) {
                        table.editCellAt(row, column);
                    }
                } else if (hasFocus) {
                    SwingUtility.pressKey(9);
                }
            }
            this.setAlingment(value);
            return label;
        }

        public void setAlingment(Object value) {
            try {
                if (value == null || value.equals("-") || value.toString().contains("%")) {
                    this.setHorizontalAlignment(0);
                } else {
                    Double.parseDouble(value.toString());
                }
                this.setHorizontalAlignment(0);
            }
            catch (NumberFormatException e) {
                this.setHorizontalAlignment(10);
                this.setBorder(gap);
            }
        }
    }
}

