/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class RoundButton
extends Component {
    private static final long serialVersionUID = 2687577445893395660L;
    ActionListener actionListener;
    String label;
    protected boolean pressed = false;

    public RoundButton() {
        this("");
    }

    public RoundButton(String label) {
        this.label = label;
        this.enableEvents(16L);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
        this.enableEvents(16L);
    }

    @Override
    public boolean contains(int x, int y) {
        int mx = this.getSize().width / 2;
        int my = this.getSize().height / 2;
        return (mx - x) * (mx - x) + (my - y) * (my - y) <= mx * mx;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int max = Math.max(fm.stringWidth(this.label) + 40, fm.getHeight() + 40);
            return new Dimension(max, max);
        }
        return new Dimension(100, 100);
    }

    @Override
    public void paint(Graphics g) {
        int s = Math.min(this.getSize().width - 1, this.getSize().height - 1);
        if (this.pressed) {
            g.setColor(this.getBackground().darker().darker());
        } else {
            g.setColor(this.getBackground());
        }
        g.fillArc(0, 0, s, s, 0, 360);
        g.setColor(this.getBackground().darker().darker().darker());
        g.drawArc(0, 0, s, s, 0, 360);
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.setColor(this.getForeground());
            g.drawString(this.label, s / 2 - fm.stringWidth(this.label) / 2, s / 2 + fm.getMaxDescent());
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.pressed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
            case 504: {
                break;
            }
            case 505: {
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void setLabel(String label) {
        this.label = label;
        this.invalidate();
        this.repaint();
    }
}

