/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationParameters;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.util.JKIOUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JKWebBrowser
extends JKPanel {
    private static final long serialVersionUID = 1L;
    private InputStream in;
    private JWebBrowser browser;
    private URL url;
    private Map<String, String> postParamters;
    private Map<String, String> headers;

    public JKWebBrowser() {
        this.init();
    }

    public JKWebBrowser(InputStream in) throws IOException {
        this.init();
        byte[] data = JKIOUtil.readStream(in);
        File file = JKIOUtil.writeDataToTempFile(data, ".html");
        this.setUrl(file.toURL());
    }

    public JKWebBrowser(URL url) throws IOException {
        this.init();
        this.setUrl(url);
    }

    public JKWebBrowser(String url) throws MalformedURLException {
        this();
        this.setUrl(new URL(url));
    }

    public void setUrl(final URL url) {
        this.url = url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JKWebBrowser.this.browser.navigate(url.toString(), JKWebBrowser.this.getParamters());
            }
        });
    }

    protected WebBrowserNavigationParameters getParamters() {
        WebBrowserNavigationParameters p = new WebBrowserNavigationParameters();
        p.setPostData(this.postParamters);
        p.setHeaders(this.headers);
        return p;
    }

    private void init() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getBrowserPanel(), "Center");
        this.initBrowser();
    }

    private void initBrowser() {
        this.browser.setMenuBarVisible(true);
    }

    private JPanel getBrowserPanel() {
        this.browser = new JWebBrowser(new NSOption[0]);
        this.browser.setMenuBarVisible(false);
        this.browser.setLocationBarVisible(false);
        return this.browser;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SwingUtility.testPanel(new JKWebBrowser("http://www.google.com"));
    }

    public void setUrl(String url) throws MalformedURLException {
        this.setUrl(new URL(url));
    }

    public void setPostParamters(Map<String, String> postParamters) {
        this.postParamters = postParamters;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static void clearSession() {
    }
}

