/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.tree.JKTreeModel;
import com.jk.desktop.util.TreeUtil;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class JKTree
extends JTree {
    private static final long serialVersionUID = 2354424326770047463L;

    public JKTree() {
        this.init();
    }

    public JKTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public JKTree(Object[] value) {
        super(value);
        this.init();
    }

    public JKTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public JKTree(TreeNode root) {
        super(new JKTreeModel(root, false));
        this.init();
    }

    public JKTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JKTree(Vector<?> value) {
        super(value);
        this.init();
    }

    public void addActionListener(final ActionListener listener) {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = JKTree.this.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() != 1 && e.getClickCount() == 2) {
                    listener.actionPerformed(null);
                }
            }
        };
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    listener.actionPerformed(null);
                }
            }
        };
        this.addMouseListener(ml);
        this.addKeyListener(kl);
    }

    public ArrayList<TreeNode> getNodesAsArray() {
        return TreeUtil.toArray(this.getRoot());
    }

    public TreeNode getRoot() {
        return (TreeNode)this.getModel().getRoot();
    }

    private void init() {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void refresh() {
        this.invalidate();
        this.repaint();
    }

    public TreeNode searchNode(TreeNode nodeToFind, TreeNode searchFrom) {
        if (searchFrom == null) {
            searchFrom = (TreeNode)this.getModel().getRoot();
        }
        if (searchFrom.equals(nodeToFind)) {
            return searchFrom;
        }
        Enumeration<? extends TreeNode> children = searchFrom.children();
        while (children.hasMoreElements()) {
            TreeNode node = this.searchNode(nodeToFind, children.nextElement());
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

