/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.SwingValidator;
import com.jk.desktop.swing.comp.JKComboBox;
import com.jk.desktop.swing.comp.JKLabel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.locale.JKMessage;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;

public class JKTime
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    private JKComboBox cmbMin = null;
    private JKComboBox cmbHour = null;
    private int toHour;
    private int fromHour;
    private Object defaultValue;

    public static void main(String[] args) {
        JKTime t = new JKTime("Time ");
        t.setTime(new Date());
        System.out.println(t.getTime());
    }

    public JKTime() {
    }

    public JKTime(String lableKey) {
        this(JKMessage.get(lableKey, new Object[0]), 8, 24);
    }

    public JKTime(String lableKey, int fromHour, int toHour) {
        this.fromHour = fromHour;
        this.toHour = toHour;
        this.initialize();
    }

    public void checkValue() {
        SwingValidator.checkEmpty(this.cmbHour);
        SwingValidator.checkEmpty(this.cmbMin);
    }

    @Override
    public void clear() {
        this.setValue((Object)null);
    }

    private JComboBox getCmbHour() {
        if (this.cmbHour == null) {
            this.cmbHour = new JKComboBox();
            for (int i = this.fromHour; i <= this.toHour; ++i) {
                this.cmbHour.addItem(new Integer(i));
            }
        }
        return this.cmbHour;
    }

    private JComboBox getCmbMin() {
        if (this.cmbMin == null) {
            this.cmbMin = new JKComboBox();
            for (int i = 0; i < 60; i += 5) {
                this.cmbMin.addItem(new Integer(i));
            }
        }
        return this.cmbMin;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Date getTime() {
        if (this.isNull()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int min = (Integer)this.cmbMin.getSelectedItem();
        int hour = (Integer)this.cmbHour.getSelectedItem();
        cal.setTimeInMillis(0L);
        cal.set(12, min);
        cal.set(11, hour);
        return cal.getTime();
    }

    public String getTimeAsString() {
        if (this.cmbMin.getSelectedIndex() == -1) {
            return null;
        }
        int min = (Integer)this.cmbMin.getSelectedItem();
        int hour = (Integer)this.cmbHour.getSelectedItem();
        return hour + ":" + min;
    }

    @Override
    public Date getValue() {
        this.checkValue();
        return this.getTime();
    }

    private void initialize() {
        JKLabel lbl = new JKLabel(":");
        lbl.setPreferredSize(new Dimension(8, 25));
        this.add(this.getCmbHour());
        this.add(lbl);
        this.add(this.getCmbMin());
    }

    public boolean isNull() {
        return this.cmbMin.getSelectedIndex() == -1 && this.cmbHour.getSelectedIndex() == -1;
    }

    @Override
    public void requestFocus() {
        this.cmbHour.requestFocus();
    }

    @Override
    public void reset() {
        this.setValue(this.defaultValue);
    }

    public void resetDate() {
        this.cmbMin.setSelectedIndex(-1);
        this.cmbHour.setSelectedIndex(-1);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTime(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.cmbMin.setSelectedItem(cal.get(12));
            this.cmbHour.setSelectedItem(cal.get(11));
        } else {
            this.cmbMin.setSelectedIndex(-1);
            this.cmbHour.setSelectedIndex(-1);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setTime(null);
        } else if (value instanceof Date) {
            this.setTime((Date)value);
        } else {
            this.setTime(null);
        }
    }

    @Override
    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        return format.format(this.getTime());
    }
}

