/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.SwingValidator;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.TransferFocusOnEnterKeyListener;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.swing.text.documents.FloatDocument;
import com.jk.desktop.swing.text.documents.NumberDocument;
import com.jk.desktop.swing.text.documents.TextDocument;
import com.jk.locale.JKMessage;
import com.jk.util.JKConversionUtil;
import com.jk.util.JKStringUtil;
import com.jk.validation.Validator;
import com.jk.validation.builtin.FSValidators;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JKTextField
extends JTextField
implements BindingComponent {
    private static final long serialVersionUID = 1L;
    static Dimension dim = new Dimension(200, 30);
    private String defaultValue;
    private Class type;
    protected FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean numbersOnly;
    private boolean autoTrim = true;
    private boolean required;
    private int minLength;
    private int maxLength;
    private long valueFrom;
    private long valueTo;
    private String oldValue;
    private boolean autoSelectText = true;
    private boolean transfer = true;
    private String placeholder;

    static Document getDocument(FieldType type) {
        if (type == FieldType.NUMBER) {
            return new NumberDocument();
        }
        return new PlainDocument();
    }

    public JKTextField() {
        this.init();
    }

    public JKTextField(boolean editable) {
        this.init();
        this.setEditable(editable);
    }

    public JKTextField(Document document) {
        this.setDocument(document);
        this.init();
    }

    public JKTextField(Document plainDocument, int width) {
        super(plainDocument, "", width);
        this.init();
    }

    public JKTextField(Document doc, int width, boolean editable) {
        this(new PlainDocument(), width);
        this.setEditable(editable);
    }

    public JKTextField(FieldType type, int width) {
        super(JKTextField.getDocument(type), "", width);
        this.init();
    }

    public JKTextField(int width) {
        this(width, true);
    }

    public JKTextField(int width, boolean editable) {
        this((Document)new PlainDocument(), width, editable);
    }

    public JKTextField(int i, int j) {
        this(i, j, true);
    }

    public JKTextField(int maxLength, int width, boolean editable) {
        this(new TextDocument(maxLength), width);
        this.setEditable(editable);
    }

    @Override
    public void addValidator(Validator validator) {
        this.fsWrapper.addValidator(validator);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.fsWrapper.addValueChangeListsner(listener);
    }

    public void checkEmpty() {
        SwingValidator.checkEmpty(this);
    }

    protected void checkValidValue() {
        if (this.getDocument() instanceof FloatDocument) {
            try {
                Float.parseFloat(this.getText().trim());
            }
            catch (NumberFormatException e) {
                this.setText("");
            }
        }
    }

    @Override
    public void clear() {
        this.setText("");
    }

    @Override
    public void filterValues(BindingComponent comp1) {
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public String getText() {
        if (this.isAutoTrim()) {
            return super.getText().trim();
        }
        return super.getText();
    }

    public double getTextAsDouble() {
        return JKConversionUtil.toDouble(this.getValue());
    }

    public float getTextAsFloat() {
        return JKConversionUtil.toFloat(this.getText());
    }

    public int getTextAsInteger() {
        return JKConversionUtil.toInteger(this.getValue());
    }

    public long getTextAsLong() {
        if (this.getText().equals("")) {
            return 0L;
        }
        return Long.parseLong(this.getText());
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.getText().trim().equals("") ? null : this.getText();
    }

    public double getValueAsDouble() {
        return JKConversionUtil.toDouble(this.getValue());
    }

    public long getValueFrom() {
        return this.valueFrom;
    }

    public long getValueTo() {
        return this.valueTo;
    }

    protected void handleCopyText() {
        JKStringUtil.copyToClipboard(this.getText());
    }

    private void init() {
        this.setDisabledTextColor(Color.DARK_GRAY);
        this.setLocale(SwingUtility.getDefaultLocale());
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.setHorizontalAlignment(10);
        this.setPreferredSize(dim);
        this.addKeyListener(new TransferFocusOnEnterKeyListener(this));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JKTextField.this.autoSelectText) {
                    JKTextField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JKTextField.this.handleCopyText();
                }
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }

    public boolean isNumbersOnly() {
        return this.numbersOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void reset() {
        this.setText(this.getDefaultValue() != null ? this.getDefaultValue() : "");
    }

    @Override
    public void selectAll() {
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
    }

    public void setAutoSelectText(boolean autoSelectText) {
        this.autoSelectText = autoSelectText;
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    public void setAutoTrim(boolean autoTrim) {
        this.autoTrim = autoTrim;
    }

    @Override
    public void setColumns(int columns) {
        System.err.println("Invalid call to setColunms at FSTextField");
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue != null && defaultValue.toString().toUpperCase().equals("NULL") ? null : defaultValue.toString();
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.getDocument() instanceof TextDocument) {
            TextDocument doc = (TextDocument)this.getDocument();
            doc.setMaxLength(maxLength);
        } else {
            this.addValidator(FSValidators.maxLength(maxLength));
        }
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
        this.addValidator(FSValidators.minLength(minLength));
    }

    @Override
    public void setName(String name) {
        super.setName(JKMessage.get(name, new Object[0]));
    }

    public void setNumbersOnly(boolean numbersOnly) {
        this.numbersOnly = numbersOnly;
        this.setDocument(new NumberDocument(this.maxLength == 0 ? 10L : (long)this.maxLength));
    }

    public void setRequired(boolean required) {
        if (required) {
            this.fsWrapper.addValidator(FSValidators.REQUIRE_NON_EMPTY_STRING);
        } else {
            this.fsWrapper.removeValidator(FSValidators.REQUIRE_NON_EMPTY_STRING);
        }
        this.required = required;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.fsWrapper != null) {
            this.fsWrapper.fireValueChangeListener(this.oldValue, text);
        }
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setValue(Object value) {
        if (value != null) {
            this.setText(JKConversionUtil.toString(value));
        } else {
            this.setText("");
        }
    }

    public void setValueFrom(long valueFrom) {
        this.valueFrom = valueFrom;
        this.addValidator(FSValidators.numberRange(valueFrom, this.valueTo));
    }

    public void setValueTo(long valueTo) {
        this.valueTo = valueTo;
        this.addValidator(FSValidators.numberRange(this.valueFrom, valueTo));
    }

    public void setWidth(int width) {
        this.setPreferredSize(new Dimension(width, 25));
    }

    @Override
    public void validateValue() {
        this.fsWrapper.validateValue();
    }

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0 || !this.isEnabled()) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.lightGray);
        g.drawString(this.placeholder, this.getInsets().left, pG.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.revalidate();
        this.repaint();
    }

    public static enum FieldType {
        TEXT,
        NUMBER,
        AMOUNT,
        DATE;

    }
}

