/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKCheckBox;
import com.jk.desktop.swing.comp.JKDate;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.listeners.CellFocusEvent;
import com.jk.desktop.swing.comp.listeners.CellFocusListener;
import com.jk.desktop.swing.comp.renderers.JKBindingComponentEditor;
import com.jk.desktop.swing.comp.renderers.JKBindingComponentRenderer;
import com.jk.desktop.swing.comp.renderers.JKDefaultTableRenderer;
import com.jk.desktop.swing.comp.renderers.JKTableHeaderRendere;
import com.jk.desktop.swing.listener.RecordSelectionListener;
import com.jk.desktop.swing.text.documents.FloatDocument;
import com.jk.desktop.util.JKColors;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.util.JKConversionUtil;
import com.jk.util.JKDateTimeUtil;
import com.jk.util.JKObjectUtil;
import com.jk.util.model.table.JKTableColumn;
import com.jk.util.model.table.JKTableModel;
import com.jk.util.model.table.JKTableRecord;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JKTable
extends JTable {
    private static JKLogger logger = JKLoggerFactory.getLogger(JKTable.class);
    private static final long serialVersionUID = 1L;
    private final TableFocusListener tableFocusListener = new TableFocusListener();
    Vector<CellFocusListener> focusListsner = new Vector();
    private final boolean confirmDelete = true;
    private int lastSelectedRow;
    private int lastSelectedColunm;
    private boolean allowAddNew;
    private List<RecordSelectionListener> selectionListeners = new Vector<RecordSelectionListener>();

    public JKTable() {
        this(new JKTableModel());
    }

    public JKTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public void addCellFocusListener(CellFocusListener cellFocusListener) {
        this.focusListsner.add(cellFocusListener);
    }

    public void addTableColumn(JKTableColumn col) {
        this.getJKModel().addJKTableColumn(col);
    }

    public int addRow() {
        return this.addRows(1);
    }

    public int addRows(int size) {
        for (int i = 0; i < size; ++i) {
            TableModel model = this.getModel();
            if (!(model instanceof JKTableModel)) continue;
            JKTableModel defaultModel = (JKTableModel)model;
            defaultModel.addRecord();
            this.setSelectedRow(model.getRowCount() - 1);
            this.setSelectedColumn(0);
        }
        return this.getRowCount() - 1;
    }

    private void checkCellFocusChanged() {
        int selectedRow = this.getSelectedRow();
        int selectedColunm = this.getSelectedColumn();
        if (selectedRow != this.lastSelectedRow || selectedColunm != this.lastSelectedColunm) {
            this.lastSelectedRow = this.getSelectedRow();
            int focusLostColumn = this.lastSelectedColunm;
            this.lastSelectedColunm = this.getSelectedColumn();
            this.fireCellFocusLost(this.lastSelectedRow, focusLostColumn);
            if (this.lastSelectedColunm == -1 || this.lastSelectedColunm == -1) {
                return;
            }
            this.fireCellFocusGained(this.lastSelectedRow, this.lastSelectedColunm);
        }
    }

    public void clearRecords() {
        this.getJKModel().clearRecords();
    }

    public void deleteRow(int row) {
        this.getJKModel().deleteRow(row);
    }

    @Override
    public boolean editCellAt(int row, int column) {
        boolean editCellAt = super.editCellAt(row, column);
        if (editCellAt) {
            // empty if block
        }
        return editCellAt;
    }

    protected void fireCellFocusGained(int row, int col) {
        for (CellFocusListener f : this.focusListsner) {
            f.focusGained(new CellFocusEvent(this, row, col));
        }
    }

    protected void fireCellFocusLost(int row, int col) {
        for (CellFocusListener f : this.focusListsner) {
            f.focusLost(new CellFocusEvent(this, row, col));
        }
    }

    public void fireTableCellUpdated(int row, int col) {
        this.getJKModel().fireTableCellUpdated(row, col);
    }

    public void fireTableColumnDataChanged(int col) {
        this.getJKModel().fireTableColumnDataChanged(col);
    }

    public void fireTableDataChanged() {
        this.getJKModel().fireTableDataChanged();
    }

    public void fireTableStructureChanged() {
        this.getJKModel().fireTableStructureChanged();
    }

    protected void fixWidth(int column, Component comp) {
        if (this.getColumnCount() <= column) {
            return;
        }
        int userColunmWidth = this.getJKModel().getPrefferedWidth(column);
        int compWidth = comp.getPreferredSize().width;
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        if (userColunmWidth > tableColumn.getPreferredWidth()) {
            tableColumn.setPreferredWidth(userColunmWidth);
        } else {
            comp.setPreferredSize(null);
            if (compWidth > tableColumn.getPreferredWidth()) {
                tableColumn.setPreferredWidth(compWidth);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.getJKModel().getCellEditor(column);
        if (editor != null) {
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.getJKModel().getCellRenderer(column);
        if (renderer != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    public double getColunmSum(int col) {
        double sum = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            sum += this.getValueAtAsDouble(i, col);
        }
        return sum;
    }

    public Vector<Vector> getData() {
        return this.getJKModel().getRecordsAsDataVector();
    }

    public Vector<JKTableRecord> getDeletedRecords() {
        return this.getJKModel().getDeletedRecords();
    }

    public Vector<Vector> getDeletedRows() {
        return this.getJKModel().getDeletedRecordsAsDataVector();
    }

    public JKTableModel getJKModel() {
        if (this.getModel() instanceof JKTableModel) {
            return (JKTableModel)this.getModel();
        }
        throw new IllegalStateException(this.getModel().getClass().getName() + " is not instanceof FSTableModel");
    }

    public Vector<JKTableRecord> getModifiedRecords() {
        Vector<JKTableRecord> modeifiedRecords = new Vector<JKTableRecord>();
        Vector<JKTableRecord> records = this.getRecords();
        for (JKTableRecord fsTableRecord : records) {
            if (!fsTableRecord.getStatus().equals((Object)JKTableRecord.RecordStatus.MODIFIED)) continue;
            modeifiedRecords.add(fsTableRecord);
        }
        return modeifiedRecords;
    }

    public JKTableRecord getRecord(int row) {
        return this.getJKModel().getRecord(row);
    }

    public Vector<JKTableRecord> getRecords() {
        return this.getJKModel().getRecords();
    }

    public Object getValueAt(int row, int col, boolean includeVisibleColumns) {
        if (includeVisibleColumns) {
            return this.getJKModel().getRecord(row).getColumnValue(col);
        }
        return this.getValueAt(row, col);
    }

    public java.util.Date getValueAtAsDate(int row, int column) {
        Object valueAt = this.getValueAt(row, column);
        if (valueAt == null) {
            return null;
        }
        if (valueAt instanceof java.util.Date) {
            return (java.util.Date)valueAt;
        }
        return JKDateTimeUtil.parseDate(valueAt.toString());
    }

    public double getValueAtAsDouble(int i, int col) {
        String valueAt = this.getValueAtAsString(i, col);
        if (valueAt == null) {
            return 0.0;
        }
        return new Double(valueAt.toString());
    }

    public int getValueAtAsInteger(int row, int col) {
        Object valueAt = this.getValueAt(row, col);
        if (valueAt == null) {
            return 0;
        }
        if (valueAt instanceof Boolean) {
            return (Boolean)valueAt == true ? 1 : 0;
        }
        return new Integer(valueAt.toString());
    }

    public Date getValueAtAsSqlDate(int row, int col) {
        java.util.Date date = this.getValueAtAsDate(row, col);
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public String getValueAtAsString(int row, int column) {
        Object valueAt = this.getValueAt(row, column);
        if (valueAt == null || valueAt.toString().trim().equals("")) {
            return null;
        }
        return valueAt.toString().trim();
    }

    protected void handleDeleteRow() {
        TableModel model;
        if (this.isAllowDelete() && (model = this.getModel()) instanceof JKTableModel) {
            JKTableModel defaultModel = (JKTableModel)model;
            int[] selectedRows = this.getSelectedRows();
            if (!this.isConfirmDelete() || this.isConfirmDelete() && SwingUtility.showConfirmationDialog("YOU_ARE_ABOUT_TO_DELETE_THIS_ROW,ARE_YOU_SURE?")) {
                defaultModel.deleteRows(selectedRows);
            }
        }
    }

    protected void handleFocusGained() {
        this.checkCellFocusChanged();
    }

    protected void handleFocusLost() {
        this.checkCellFocusChanged();
    }

    protected void handleInsertRow() {
        TableModel model;
        if (this.isEditable() && this.isAddNewRow() && (model = this.getModel()) instanceof JKTableModel) {
            JKTableModel defaultModel = (JKTableModel)model;
            int selectedRow = this.getSelectedRow();
            defaultModel.insertRecord(selectedRow);
            this.setSelectedRow(selectedRow);
            this.setSelectedColumn(0);
        }
    }

    protected void handleKeyDownPressed() {
        if (this.isEditable() && this.getSelectedRow() == this.getModel().getRowCount() - 1 && this.isAddNewRow()) {
            this.addRow();
        }
    }

    protected void handleKeyReleased(KeyEvent e) {
        this.checkCellFocusChanged();
    }

    protected void handleMouseClicked() {
        this.checkCellFocusChanged();
    }

    protected void handleTableStuctorChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JKTableModel model = JKTable.this.getJKModel();
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    TableColumn column = JKTable.this.getColumnModel().getColumn(i);
                    int textWidth = SwingUtility.getTextWidth(model.getColumnName(i), true) + 10;
                    column.setMinWidth(textWidth);
                    column.setPreferredWidth(textWidth);
                }
            }
        });
    }

    protected void init() {
        this.initTableHeader();
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSurrendersFocusOnKeystroke(true);
        this.setAutoResizeMode(0);
        this.setOpaque(false);
        this.setRowHeight(25);
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.setDefaultEditors();
        this.setDefaultRenderers();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JKTable.this.handleFocusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JKTable.this.handleFocusLost();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JKTable.this.handleKeyReleased(e);
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == -1) {
                    JKTable.this.handleTableStuctorChanged();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    JKTable.this.fireRecordSelectedEvent(JKTable.this.getSelectedRow());
                }
            }
        });
    }

    protected void fireRecordSelectedEvent(int selectedRow) {
        for (RecordSelectionListener recordSelectionListener : this.selectionListeners) {
            recordSelectionListener.recordSelected(selectedRow);
        }
    }

    protected void initTableHeader() {
        this.getTableHeader().setDefaultRenderer(new JKTableHeaderRendere());
        this.getTableHeader().setBackground(JKColors.MAIN_PANEL_BG);
    }

    protected boolean isAddNewRow() {
        if (this.getRowCount() > 0) {
            boolean validData = this.getJKModel().isAllDataValid();
            return validData;
        }
        return this.isAllowAddNew();
    }

    public boolean isAllowAddNew() {
        return this.allowAddNew;
    }

    public boolean isAllowDelete() {
        return this.getJKModel().isAllowDelete();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getJKModel().isEditable(row, column);
    }

    public boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    public boolean isDataModified() {
        return this.getJKModel().isDataModified();
    }

    public boolean isEditable() {
        return this.getJKModel().isEditable();
    }

    public boolean isEditable(int column) {
        return this.getJKModel().isEditable(column);
    }

    protected void moveSelectionToRow(int row, int column) {
        this.setSelectionRow(row, column);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component field = super.prepareEditor(editor, row, column);
        this.fixWidth(column, field);
        FocusListener[] focusListeners = field.getFocusListeners();
        boolean listenerRegistred = false;
        for (FocusListener focusListener : focusListeners) {
            if (!(focusListener instanceof TableFocusListener)) continue;
            listenerRegistred = true;
        }
        if (!listenerRegistred) {
            field.addFocusListener(this.tableFocusListener);
        }
        return field;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component comp = super.prepareRenderer(renderer, row, column);
        this.fixWidth(column, comp);
        this.checkCellFocusChanged();
        return comp;
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!SwingUtility.isLeftOrientation()) {
            if (ks == KeyStroke.getKeyStroke(39, 0)) {
                return super.processKeyBinding(KeyStroke.getKeyStroke(37, 0), e, condition, pressed);
            }
            if (ks == KeyStroke.getKeyStroke(37, 0)) {
                return super.processKeyBinding(KeyStroke.getKeyStroke(39, 0), e, condition, pressed);
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void resetRecords() {
        this.getJKModel().resetRecords();
    }

    public void setAllowAddNew(boolean allowAddNew) {
        this.allowAddNew = allowAddNew;
    }

    public void setAllowDelete(boolean allowDelete) {
        this.getJKModel().setAllowDelete(allowDelete);
    }

    public void setAlowMutipleSelection(boolean enable) {
        this.getSelectionModel().setSelectionMode(enable ? 2 : 0);
    }

    public void setColumnDateFormat(int col, String format) {
        this.getJKModel().setFormatter(col, new SimpleDateFormat(format));
    }

    private void setColumnFormat(int col, Format format) {
        this.getJKModel().setFormatter(col, format);
    }

    public void setColumnName(int col, String name) {
        this.getColumnModel().getColumn(col).setHeaderValue(name);
    }

    public void setColumnNumberFormat(int col, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        this.setColumnFormat(col, format);
    }

    public void setColumnPrefereddWidth(int col, int width) {
        this.getJKModel().setPreferredWidth(col, width);
    }

    public void setColumnValue(int row, int col, Object value) {
        this.setColumnValue(row, col, value, true);
    }

    public void setColumnValue(int row, int col, Object value, boolean visibleIndex) {
        this.getJKModel().setColumnValue(row, col, value, visibleIndex);
    }

    public boolean setColunmEditor(int colunm, BindingComponent comp) {
        JKBindingComponentEditor cellEditor = new JKBindingComponentEditor(comp);
        this.getJKModel().setEditor(colunm, cellEditor);
        BindingComponent copy = (BindingComponent)JKObjectUtil.copy(comp);
        if (copy != null) {
            this.setColunmRenderer(colunm, copy);
            return true;
        }
        return false;
    }

    public void setColunmRenderer(int col, BindingComponent component) {
        JKBindingComponentRenderer cellRenderer = new JKBindingComponentRenderer(component);
        this.getJKModel().setRenderer(col, cellRenderer);
    }

    public void setDefaultEditors() {
        JKTextField txtInteger = new JKTextField();
        JKTextField txtAmount = new JKTextField(new FloatDocument());
        JKTextField txt = new JKTextField();
        this.setDefaultEditor(java.util.Date.class, new JKBindingComponentEditor(new JKDate()));
        this.setDefaultEditor(Boolean.class, new JKBindingComponentEditor(new JKCheckBox()));
        txtInteger.setNumbersOnly(true);
        this.setDefaultEditor(Integer.class, new JKBindingComponentEditor(txtInteger));
        this.setDefaultEditor(Double.class, new JKBindingComponentEditor(txtAmount));
        this.setDefaultEditor(BigDecimal.class, new JKBindingComponentEditor(txtAmount));
        this.setDefaultEditor(String.class, new JKBindingComponentEditor(txt));
    }

    protected void setDefaultRenderers() {
        JKDefaultTableRenderer fsDefaultTableRenderer = new JKDefaultTableRenderer();
        this.setDefaultRenderer(Object.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(Number.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(Float.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(Double.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(java.util.Date.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(Icon.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(ImageIcon.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(Boolean.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(BigDecimal.class, fsDefaultTableRenderer);
        this.setDefaultRenderer(String.class, fsDefaultTableRenderer);
    }

    public void setEditable(boolean editable) {
        this.getJKModel().setEditable(editable);
    }

    public void setEditable(int column, boolean editable) {
        this.getJKModel().setEditable(column, editable);
    }

    public void setEditable(int row, int col, boolean enable) {
        this.getJKModel().setEditable(row, col, enable);
    }

    @Override
    public void setModel(TableModel model) {
        logger.debug("setModel :", model != null ? model.getClass().getName() : "NULL");
        if (!(model instanceof JKTableModel)) {
            throw new IllegalStateException("FSTable only accept FSTableModel");
        }
        super.setModel(model);
        this.handleTableStuctorChanged();
    }

    public void setRequiredColumn(int col, boolean required) {
        this.getJKModel().setRequired(col, required);
    }

    private void setSelectedColumn(int col) {
        this.setColumnSelectionInterval(col, col);
    }

    private void setSelectedColunm(int column) {
        this.setColumnSelectionInterval(column, column);
    }

    public void setSelectedRow(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int newIndex = index;
                if ((index >= JKTable.this.getModel().getRowCount() || index == -1) && JKTable.this.getModel().getRowCount() > 0) {
                    newIndex = 0;
                }
                if (newIndex >= 0 && JKTable.this.getRowCount() > 0 && JKTable.this.getColumnCount() > 0) {
                    JKTable.this.setRowSelectionInterval(newIndex, newIndex);
                    JKTable.this.scrollRectToVisible(JKTable.this.getCellRect(newIndex, 0, true));
                }
            }
        });
    }

    private void setSelectionRow(final int row, final int column) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (row >= JKTable.this.getModel().getRowCount() || row == -1) {
                    if (JKTable.this.getModel().getRowCount() > 0) {
                        JKTable.this.setRowSelectionInterval(0, 0);
                    }
                } else {
                    JKTable.this.setRowSelectionInterval(row, row);
                }
                JKTable.this.setSelectedColunm(column);
            }
        });
    }

    public void setVisible(int col, boolean visible) {
        this.getJKModel().setVisible(col, visible);
    }

    public void stopEditing() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public void transferFocusToNextColunm() {
        int row = this.getSelectedRow();
        int column = this.getSelectedColumn() + 1;
        if (column == this.getColumnCount()) {
            column = 0;
            if (++row == this.getRowCount()) {
                row = 0;
            }
        }
        this.moveSelectionToRow(row, column);
    }

    public Boolean getValueAtAsBoolean(int row, int col) {
        return JKConversionUtil.toBoolean(this.getValueAt(row, col));
    }

    public int findValueRowIndex(int col, Object value) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object rowValue = this.getValueAt(i, col);
            if (value instanceof String && rowValue != null && rowValue.toString().equalsIgnoreCase(value.toString())) {
                return i;
            }
            if (rowValue == null || !rowValue.equals(value)) continue;
            return i;
        }
        return -1;
    }

    public void addRow(Object[] objects) {
        int index = this.addRow();
        int i = 0;
        for (Object object : objects) {
            this.setValueAt(object, index, i++);
        }
    }

    public void setColumnWidth(int col, int width) {
        this.getColumnModel().getColumn(col).setMaxWidth(width);
        this.getColumnModel().getColumn(col).setPreferredWidth(width);
    }

    public void addRecordSelectionListener(RecordSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    class TableFocusListener
    extends FocusAdapter {
        TableFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JKTable.this.stopEditing();
                }
            });
        }
    }
}

