/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.SwingUtility;
import com.jk.locale.JKMessage;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class JKTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;

    public JKTabbedPane() {
        this.init();
    }

    public JKTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public JKTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(JKMessage.get(title, true), component);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(JKMessage.get(title, true), icon, component);
    }

    public void addTab(String title, String iconName, Component component) {
        if (iconName != null && !iconName.equals("") && SwingUtility.getIconURL(iconName) != null) {
            this.addTab(title, SwingUtility.getIcon(iconName), component);
        } else {
            this.addTab(title, component);
        }
    }

    void init() {
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JKTabbedPane.this.transferFocus();
            }
        });
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(JKMessage.get(title, true), icon, component, tip, index);
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        this.getSelectedComponent().requestFocus();
    }

    static {
        UIManager.put("TabbedPane.selected", SwingUtility.getDefaultBackgroundColor());
    }
}

