/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.locale.JKMessage;
import com.jk.validation.Validator;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JRadioButton;

public class JKRadioButton
extends JRadioButton
implements BindingComponent<Object> {
    private static final long serialVersionUID = 1L;
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean defaultValue;
    private final Font font = new Font("Arial", 0, 10);
    private boolean transfer;

    public JKRadioButton() {
        this("");
    }

    public JKRadioButton(String caption) {
        super(caption, true);
        this.setPreferredSize(null);
        this.setOpaque(false);
        this.init();
    }

    public JKRadioButton(String string, boolean focusable) {
        this(string);
        this.setFocusable(focusable);
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public void clear() {
        this.setSelected(false);
    }

    @Override
    public void filterValues(BindingComponent comp1) {
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Boolean getValue() {
        return this.isSelected();
    }

    void init() {
        this.setFont(this.font);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JKRadioButton.this.transferFocus();
                }
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    @Override
    public void reset() {
        this.setSelected(this.defaultValue);
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue.equals("1")) {
                this.setDefaultValue((Object)true);
            } else {
                this.setDefaultValue((Object)Boolean.parseBoolean(defaultValue.toString()));
            }
        } else {
            defaultValue = false;
        }
    }

    @Override
    public void setText(String text) {
        super.setText(JKMessage.get(text, new Object[0]));
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.setSelected(Boolean.parseBoolean(value.toString()));
        }
    }

    @Override
    public void validateValue() {
    }
}

