/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.SwingValidator;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.swing.text.documents.TextDocument;
import com.jk.validation.Validator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPasswordField;
import javax.xml.bind.ValidationException;

public class JKPasswordField
extends JPasswordField
implements BindingComponent<String> {
    private static final long serialVersionUID = 1L;
    static Dimension dim = new Dimension(200, 30);
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private String defaultValue;
    private boolean transfer;
    private String placeholder;

    public JKPasswordField() {
        this(10, 10);
    }

    public JKPasswordField(int maxlength, int col) {
        super(new TextDocument(maxlength), "", col);
        this.init();
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    public void checkEmpty() throws ValidationException {
        SwingValidator.checkEmpty(this);
    }

    @Override
    public void clear() {
    }

    @Override
    public void filterValues(BindingComponent component) {
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    private void init() {
        this.setPreferredSize(dim);
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        SwingUtility.setFont(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JKPasswordField.this.transferFocus();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JKPasswordField.this.setSelectionStart(0);
                JKPasswordField.this.setSelectionEnd(JKPasswordField.this.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    @Override
    public void reset() {
        this.setText(this.getDefaultValue() != null ? this.getDefaultValue() : "");
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void setColumns(int columns) {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    public void validateValue() {
    }

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.lightGray);
        g.drawString(this.placeholder, this.getInsets().left, pG.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.revalidate();
        this.repaint();
    }
}

