/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.util.JKColors;
import com.jk.locale.JKMessage;
import com.jk.validation.Validator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JKLabel
extends JLabel
implements BindingComponent<String> {
    private static final long serialVersionUID = 1L;
    static Font font = new Font("Arial", 1, 12);
    static Color BG_COLOR = JKColors.JK_LABEL_BG;
    static Color FG_COLOR = JKColors.JK_LABEL_FG;
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private String defaultValue;
    private boolean captilize;
    private boolean transfer;

    public JKLabel() {
        this.init();
    }

    public JKLabel(Icon image) {
        this();
        this.setIcon(image);
    }

    public JKLabel(Icon image, int horizontalAlignment) {
        this();
        this.setIcon(image);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public JKLabel(String lableKey) {
        this(lableKey, true);
    }

    public JKLabel(String lableKey, boolean setSize) {
        super(JKMessage.get(lableKey, true));
        if (setSize) {
            this.setPreferredSize(new Dimension(80, 30));
        }
        this.init();
    }

    public JKLabel(String text, Icon icon, int horizontalAlignment) {
        this(text);
        this.setIcon(icon);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public JKLabel(String text, int horizontalAlignment) {
        this(text);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public void clear() {
        this.setText("");
    }

    @Override
    public void filterValues(BindingComponent component) {
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValue() {
        return this.getText().trim();
    }

    void init() {
        this.setToolTipText(this.getText());
        this.setBackground(BG_COLOR);
        this.setForeground(FG_COLOR);
        this.setOpaque(true);
        this.setLocale(SwingUtility.getDefaultLocale());
        this.setFocusable(false);
        this.setHorizontalAlignment(0);
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            super.paint(g);
        } else {
            super.paint(g);
        }
    }

    public void removeIcon() {
        super.setIcon(null);
    }

    @Override
    public void reset() {
        this.setText(this.defaultValue);
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    public void setCaptilize(boolean captilize) {
        this.captilize = captilize;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setIcon(String iconName) {
        if (SwingUtility.getIconURL(iconName) != null) {
            this.setIcon(SwingUtility.getIcon(iconName));
        }
    }

    @Override
    public void setText(String text) {
        String txt = JKMessage.get(text, this.captilize);
        super.setText(txt);
        this.setToolTipText(text);
    }

    @Override
    public void setValue(String value) {
        this.setText(value.trim());
    }

    @Override
    public void validateValue() {
    }
}

