/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.util.SwingPrintUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JKImageThumb
extends JKPanel {
    private static final long serialVersionUID = 1L;
    JPanel pnlImage;
    byte[] imageData;

    public JKImageThumb(byte[] image) {
        this.imageData = image;
        this.pnlImage = SwingUtility.buildImagePanel(image, 1);
        this.init();
    }

    protected void handleShowImage() {
        final JKPanel pnl = new JKPanel(new BorderLayout());
        final JPanel pnlImage = SwingUtility.buildImagePanel(this.imageData, 1);
        pnlImage.setPreferredSize(new Dimension(450, 600));
        JKPanel pnlButtons = new JKPanel();
        JKButton btnPrint = new JKButton("Print");
        JKButton btnClose = new JKButton("Close");
        btnPrint.setIcon("fileprint.png");
        btnClose.setIcon("cancel.png");
        pnlButtons.add(btnPrint);
        pnlButtons.add(btnClose);
        pnlImage.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.BLUE));
        pnl.add((Component)pnlImage, "Center");
        pnl.add(pnlButtons, "South");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtility.closePanelWindow(pnl);
            }
        });
        btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingPrintUtility.printComponent(pnlImage);
            }
        });
        SwingUtility.showPanelInDialog(pnl, "Preview");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.pnlImage.setPreferredSize(new Dimension(100, 100));
        this.setBorder(BorderFactory.createLineBorder(Color.ORANGE));
        this.add((Component)this.pnlImage, "Center");
        this.pnlImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    JKImageThumb.this.handleShowImage();
                }
            }
        });
    }
}

