/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.panels.JKImagePanel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.util.JKColors;
import com.jk.locale.JKMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JKFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    JComponent centerPanel;
    JPanel homePanel = new JKPanel();
    private boolean showAnotherPanel;

    public JKFrame() {
        this.initFrame();
    }

    public JKFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initFrame();
    }

    public JKFrame(String title) throws HeadlessException {
        super(JKMessage.get(title, new Object[0]));
        this.initFrame();
    }

    public JKFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initFrame();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public JPanel getHomePanel() {
        return this.homePanel;
    }

    public void handleShowPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        this.showAnotherPanel = true;
        if (this.centerPanel != null) {
            this.remove(this.centerPanel);
        }
        panel.applyComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.add((Component)panel, "Center");
        this.centerPanel = panel;
        this.centerPanel.setBorder(BorderFactory.createBevelBorder(1, Color.DARK_GRAY, Color.black));
        this.validate();
        this.repaint();
        this.centerPanel.requestFocus();
        this.showAnotherPanel = false;
    }

    private void initFrame() {
        this.setSize(1024, 700);
        this.setBackground(JKColors.MAIN_PANEL_BG);
        this.setLocationRelativeTo(null);
        this.getInputContext().selectInputMethod(SwingUtility.getDefaultLocale());
        this.getContentPane().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() != JKFrame.this.getHomePanel() && JKFrame.this.getHomePanel() != null && !JKFrame.this.showAnotherPanel) {
                    JKFrame.this.showHomePanel();
                }
            }
        });
    }

    public void refreshComponents() {
        this.validate();
        this.repaint();
    }

    public void setBackgroundImage(String image, int type) {
        this.setHomePanel(new JKImagePanel(SwingUtility.getImage(image), type));
        this.showHomePanel();
    }

    public void setHomePanel(JPanel homePanel) {
        this.homePanel = homePanel;
        this.handleShowPanel(homePanel);
    }

    public void setRightToLeft() {
        this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(JKMessage.get(title, new Object[0]));
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    public void showHomePanel() {
        this.handleShowPanel(this.getHomePanel());
    }
}

