/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.TransferFocusOnEnterKeyListener;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.validation.exception.UIValidationException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import com.jk.util.JKDateTimeUtil;
import com.jk.util.JKFormatUtil;
import com.jk.validation.Validator;
import com.jk.validation.builtin.FSValidators;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JTextFieldDateEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.xml.bind.ValidationException;

public class JKDate
extends JDateChooser
implements BindingComponent {
    private static final long serialVersionUID = 1L;
    private Object defaultValue;
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private java.util.Date minDate;
    private java.util.Date maxDate;
    private boolean transfer = true;

    public static void main(String[] args) {
        JKDate d = new JKDate();
        d.setDate(new java.util.Date());
        JKPanel pnl = new JKPanel(d);
        SwingUtility.testPanel(pnl);
    }

    public JKDate() {
        this("Date");
    }

    public JKDate(java.util.Date date) {
        this("");
        this.setDate(date);
    }

    public JKDate(String lableKey) {
        this(lableKey, 1930, 2020);
        this.setDate(new java.util.Date());
    }

    public JKDate(String lableKey, int from, int to) {
        this.initialize();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.getEditor().addKeyListener(l);
    }

    @Override
    public void addValidator(Validator validator) {
        this.fsWrapper.addValidator(validator);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.fsWrapper.addValueChangeListsner(listener);
    }

    public void checkAfterToday() throws ValidationException {
        if (this.getDate().after(new java.util.Date())) {
            throw new ValidationException("DATE_IS_AFTER_TODAY");
        }
    }

    public void checkValue() {
        if (this.getValue() == null && !this.isEmpty()) {
            throw new UIValidationException("INVALID_DATE_VALUE", (BindingComponent)this);
        }
    }

    @Override
    public void clear() {
        this.setValue((Object)null);
    }

    @Override
    public void filterValues(BindingComponent comp1) {
    }

    public Object getCellEditorValue() {
        return this.getValue();
    }

    @Override
    public java.util.Date getDate() {
        java.util.Date date = super.getDate();
        if (date != null && this.getEditor().getForeground() == Color.red) {
            date = null;
        }
        return date;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private JFormattedTextField getEditor() {
        return (JTextFieldDateEditor)this.getDateEditor();
    }

    public java.util.Date getMaxDate() {
        return this.maxDate;
    }

    public java.util.Date getMinDate() {
        return this.minDate;
    }

    public Date getSqlDate() {
        java.util.Date date = this.getDate();
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public Object getValue() {
        java.util.Date date = this.getDate();
        return date;
    }

    private void initialize() {
        this.getEditor().setLocale(SwingUtility.getDefaultLocale());
        this.add((Component)this.calendarButton, "After");
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLocale(SwingUtility.getDefaultLocale());
        this.setDateFormatString("dd/MM/yyyy");
        this.addKeyListener(new TransferFocusOnEnterKeyListener(this));
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    public boolean isEmpty() {
        return ((JFormattedTextField)((Object)this.getDateEditor())).getText().equals("");
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.getEditor().requestFocus();
    }

    @Override
    public void reset() {
        this.setValue(this.getDefaultValue());
    }

    public void resetDate() {
        this.setDate(null);
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.getEditor() == null) {
            super.setBackground(bg);
        } else {
            this.getEditor().setBackground(bg);
        }
    }

    public void setDefaultValue(Object defaultValue) {
        if (defaultValue != null && defaultValue instanceof String && defaultValue.toString().toLowerCase().equals("now")) {
            try {
                this.defaultValue = new java.util.Date();
            }
            catch (Exception e) {
                JKExceptionUtil.handle(e);
            }
            return;
        }
        this.defaultValue = defaultValue;
    }

    public void setMaxDate(java.util.Date maxDate) {
        this.maxDate = maxDate;
        this.getDateEditor().setMaxSelectableDate(maxDate);
    }

    public void setMaxDate(String maxDate) {
        if (maxDate != null && !maxDate.trim().equals("")) {
            this.setMaxDate(JKDateTimeUtil.parseDate(maxDate));
        }
    }

    public void setMinDate(java.util.Date minDate) {
        this.minDate = minDate;
        this.getDateEditor().setMinSelectableDate(minDate);
    }

    public void setMinDate(String date) {
        if (date != null && !date.trim().equals("")) {
            this.setMinDate(JKDateTimeUtil.parseDate(date));
        }
    }

    @Override
    public void setName(String name) {
        super.setName(JKMessage.get(name, new Object[0]));
    }

    public void setRequired(boolean required) {
        if (required) {
            this.addValidator(FSValidators.REQUIRE_NON_EMPTY_STRING);
        } else {
            this.fsWrapper.removeValidator(FSValidators.REQUIRE_NON_EMPTY_STRING);
        }
    }

    public void setValue(Object value) {
        if (value == null || value.equals("null")) {
            this.setDate(null);
            return;
        }
        if (value instanceof java.util.Date) {
            this.setDate((java.util.Date)value);
        } else if (value instanceof String) {
            this.setDate(JKDateTimeUtil.parseDate(value.toString()));
        }
    }

    @Override
    public String toString() {
        return JKFormatUtil.formatDate(this.getDate());
    }

    public String toString(String pattern) {
        return JKFormatUtil.formatDate(this.getDate(), pattern);
    }

    @Override
    public void validateValue() {
        this.fsWrapper.validateValue();
        this.checkValue();
    }
}

