/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.SwingValidator;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.FSComboBoxListCellRenderer;
import com.jk.desktop.swing.comp.listeners.TransferFocusOnEnterKeyListener;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.validation.Validator;
import com.jk.validation.builtin.FSValidators;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.xml.bind.ValidationException;

public class JKComboBox
extends JComboBox
implements BindingComponent<Object> {
    private static final long serialVersionUID = 1L;
    private boolean transferFocusOnEnter = true;
    private boolean useTabEventForLostFocus = true;
    private Object defaultValue;
    protected FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean required;

    public JKComboBox() {
        this.init();
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
    }

    public void addItems(List objects) {
        for (Object object : objects) {
            this.addItem(object);
        }
    }

    @Override
    public void addValidator(Validator validator) {
        this.fsWrapper.addValidator(validator);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.fsWrapper.addValueChangeListsner(listener);
    }

    public void checkEmpty() throws ValidationException {
        SwingValidator.checkEmpty(this);
    }

    @Override
    public void clear() {
        this.setSelectedIndex(-1);
    }

    @Override
    public void filterValues(BindingComponent component) {
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object getValue() {
        if (this.getSelectedIndex() != -1) {
            return this.getSelectedItem();
        }
        return null;
    }

    private void handleTransferFocus() {
        if (this.isUseTabEventForLostFocus()) {
            SwingUtility.pressKey(9);
        } else {
            this.transferFocus();
        }
    }

    private void init() {
        this.setOpaque(false);
        SwingUtility.setFont(this);
        this.setRenderer(new FSComboBoxListCellRenderer());
        this.addKeyListener(new TransferFocusOnEnterKeyListener(this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    JKComboBox.this.setSelectedIndex(-1);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transferFocusOnEnter;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isTransferFocusOnEnter() {
        return this.transferFocusOnEnter;
    }

    public boolean isUseTabEventForLostFocus() {
        return this.useTabEventForLostFocus;
    }

    @Override
    public void reset() {
        this.setSelectedItem(this.defaultValue);
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transferFocusOnEnter = transfer;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.addValidator(FSValidators.REQUIRE_NON_EMPTY_STRING);
        this.required = required;
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index >= this.getItemCount() ? -1 : index);
    }

    public void setTransferFocusOnEnter(boolean transferFocusOnEnter) {
        this.transferFocusOnEnter = transferFocusOnEnter;
    }

    public void setUseTabEventForLostFocus(boolean useTabEventForLostFocus) {
        this.useTabEventForLostFocus = useTabEventForLostFocus;
    }

    @Override
    public void setValue(Object o) {
        this.setSelectedItem(o);
    }

    @Override
    public void validateValue() {
        this.fsWrapper.validateValue();
    }
}

