/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.locale.JKMessage;
import com.jk.validation.Validator;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;

public class JKCheckBox
extends JCheckBox
implements BindingComponent<Object> {
    private static final long serialVersionUID = 1L;
    private final Font font = new Font("arial", 0, 12);
    boolean defaultValue;
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean transfer;

    public JKCheckBox() {
        this("");
    }

    public JKCheckBox(String caption) {
        super(JKMessage.get(caption, new Object[0]));
        this.setBackground(SwingUtility.getDefaultBackgroundColor());
        this.init();
    }

    public JKCheckBox(String caption, boolean checked) {
        this(caption);
        this.setSelected(checked);
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public void clear() {
        this.setSelected(false);
    }

    @Override
    public void filterValues(BindingComponent component) {
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Boolean getValue() {
        return this.isSelected();
    }

    void init() {
        this.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        this.setHorizontalAlignment(10);
        this.setFont(this.font);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JKCheckBox.this.transferFocus();
                }
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void reset() {
        this.setSelected(this.defaultValue);
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue != null ? (defaultValue.equals("1") ? true : Boolean.parseBoolean(defaultValue.toString())) : false;
    }

    @Override
    public void setText(String text) {
        super.setText(JKMessage.get(text, new Object[0]));
    }

    @Override
    public void setValue(Object value) {
        value = value != null ? (value.toString().trim().equals("1") || value.toString().trim().toLowerCase().equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        this.setSelected((Boolean)value);
    }

    @Override
    public void validateValue() {
    }
}

