/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.FSAbstractComponent;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.swing.dialogs.JKProgressDialog;
import com.jk.desktop.util.JKColors;
import com.jk.exceptions.JKNonPrintableException;
import com.jk.exceptions.JKNotAllowedOperationException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import com.jk.security.JKPrivilige;
import com.jk.security.JKSecurityManager;
import com.jk.util.JKStringUtil;
import com.jk.validation.Validator;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JKButton
extends JButton
implements BindingComponent {
    private static final long serialVersionUID = 1L;
    static Color BACKGROUND_COLOR = JKColors.JK_BUTTON_BG;
    static Color FORGROUND_COLOR = JKColors.JK_BUTTON_FG;
    private String shortcut;
    private boolean showProgress = false;
    private JKProgressDialog progress;
    private JKPrivilige privlige;
    private boolean progressAsModal;
    private final FSAbstractComponent fsWrapper = new FSAbstractComponent(this);
    private boolean authorized = true;
    private boolean transfer;
    private boolean lightView;

    public JKButton() {
        this("");
    }

    public JKButton(ImageIcon imageIcon) {
        this("");
        this.setIcon(imageIcon);
    }

    public JKButton(String caption) {
        this(caption, false, "");
    }

    public JKButton(String caption, boolean leadingAligned) {
        this(caption, leadingAligned, "");
    }

    public JKButton(String caption, boolean leadingAligned, String shortcut) {
        super(caption);
        if (leadingAligned) {
            this.setHorizontalTextPosition(10);
        }
        this.setShortcut(shortcut, shortcut);
        this.init();
    }

    public JKButton(String caption, JKPrivilige privlige) {
        this(caption, "", privlige);
    }

    public JKButton(String caption, String shortcut) {
        this(caption, false, shortcut);
    }

    public JKButton(String caption, String shortcut, boolean progress) {
        this(caption, shortcut);
        this.setShowProgress(progress);
    }

    public JKButton(String caption, String shortcut, JKPrivilige privlige) {
        this(caption, false, shortcut);
        this.setPrivlige(privlige);
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void filterValues(BindingComponent comp1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireActionPerformed(final ActionEvent event) {
        this.setEnabled(false);
        try {
            if (this.showProgress) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JKButton.super.fireActionPerformed(event);
                    }
                };
                this.progress = JKProgressDialog.create("", null, this.progressAsModal);
                this.progress.setCancellable(true);
                this.progress.addTask(runnable);
                this.progress.run();
            } else {
                JKButton.super.fireActionPerformed(event);
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof JKNonPrintableException)) {
                JKExceptionUtil.handle(e);
            }
        }
        finally {
            this.setEnabled(true);
        }
    }

    public Object getDefaultValue() {
        return null;
    }

    protected int getFontSize() {
        return SwingUtility.isLeftOrientation() ? 3 : 3;
    }

    private String getLabelAlignment() {
        return SwingUtility.isLeftOrientation() ? "left" : "right";
    }

    public JKPrivilige getPrivlige() {
        return this.privlige;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    private String getShortCutAlignment() {
        return "center";
    }

    public Object getValue() {
        return null;
    }

    void init() {
        this.setBackground(BACKGROUND_COLOR);
        this.setForeground(FORGROUND_COLOR);
        this.setSelected(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JKButton.this.doClick();
                }
            }
        });
    }

    @Override
    public boolean isAutoTransferFocus() {
        return this.transfer;
    }

    public boolean isConteniueProcessing() {
        if (this.progress != null) {
            this.progress.isConteniueProcessing();
        }
        return false;
    }

    public boolean isProgressAsModal() {
        return this.progressAsModal;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setAutoTransferFocus(boolean transfer) {
        this.transfer = transfer;
    }

    public void setDefaultValue(Object t) {
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable && this.authorized);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        if (defaultIcon != null) {
            super.setIcon(defaultIcon);
            this.setIconTextGap(2);
        }
    }

    public void setIcon(String iconName) {
        this.setIcon(SwingUtility.getIcon(iconName));
    }

    public void setPrivlige(JKPrivilige privlige) {
        if (privlige != null) {
            this.privlige = privlige;
            try {
                JKSecurityManager.checkAllowedPrivilige(privlige);
                this.authorized = true;
            }
            catch (JKNotAllowedOperationException e) {
                this.authorized = false;
                this.setEnabled(false);
            }
            catch (SecurityException e) {
                JKExceptionUtil.handle(e);
            }
        }
    }

    public void setProgressAsModal(boolean progressAsModal) {
        this.progressAsModal = progressAsModal;
    }

    public void setProgressCount(int count, int max) {
        if (this.progress != null) {
            this.progress.setProgressCount(JKMessage.get("PROCESSING_RECORD", new Object[0]) + "  :  " + count + "/" + max);
        }
    }

    public void setProgressMessage(String name) {
        if (this.progress != null) {
            this.progress.setProgressCount(name);
        }
    }

    public void setShortcut(String shortcut, String text) {
        SwingUtility.setHotKeyFoButton(this, shortcut);
        this.setShortcutText(text == null ? shortcut : text, false);
    }

    protected void setShortcutText(String shortcut, boolean pre) {
        this.setToolTipText(this.getToolTipText().concat(" ").concat(shortcut));
        if (shortcut != null && !shortcut.equals("")) {
            shortcut = JKStringUtil.capitalizeFully(shortcut);
            String htmlText = "<html><div align='" + this.getLabelAlignment() + "' width='100%'>" + "<font color=\"" + SwingUtility.colorToHex(this.getForeground()) + "\" " + "size=\"" + this.getFontSize() + "\" >" + this.getText() + "</font></div> " + "<div align='" + this.getShortCutAlignment() + "'><font size=\"1\" color=\"" + this.getShortcutColor() + "\">" + shortcut + "</font></div></html>";
            super.setText(htmlText);
        }
    }

    public String getShortcutColor() {
        return "#AA0000";
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    @Override
    public void setText(String text) {
        super.setText(JKMessage.get(text, true));
        this.setToolTipText(text);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(JKMessage.get(text, new Object[0]));
    }

    public void setValue(Object value) {
    }

    @Override
    public void validateValue() {
    }

    @Override
    public void setForeground(Color fg) {
        if (fg != null) {
            super.setForeground(fg);
        }
    }

    public void setShortcutText(String shortcut) {
        this.setShortcut(shortcut, null);
    }

    public boolean isLightView() {
        return this.lightView;
    }

    public void setLightView(boolean lightView) {
        this.lightView = lightView;
        this.setBorder(null);
        this.setOpaque(!lightView);
        if (lightView) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    JKButton.this.setOpaque(false);
                    Color background = JKButton.this.getBackground();
                    JKButton.this.setBackground(JKButton.this.getForeground());
                    JKButton.this.setForeground(background);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JKButton.this.setOpaque(true);
                    Color background = JKButton.this.getBackground();
                    JKButton.this.setBackground(JKButton.this.getForeground());
                    JKButton.this.setForeground(background);
                }
            });
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }
}

