/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing.comp;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.listeners.ValueChangeListener;
import com.jk.desktop.validation.exception.UIValidationException;
import com.jk.locale.JKMessage;
import com.jk.util.JKObjectUtil;
import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.FSValidators;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class FSAbstractComponent
implements Serializable {
    private static final long serialVersionUID = -7483362430963916031L;
    BindingComponent comp;
    private final Vector<Validator> validators = new Vector();
    private Border originalBorder;
    private String originalTooltip;
    private final Vector<ValueChangeListener> valueListeners = new Vector();

    public FSAbstractComponent(BindingComponent comp) {
        this.comp = comp;
        this.init();
    }

    public void addValidator(Validator validator) {
        int index = this.getValidatorIndex(validator);
        if (index != -1) {
            this.validators.remove(index);
        }
        this.validators.add(validator);
    }

    public void addValueChangeListsner(ValueChangeListener valueChangeListener) {
        this.valueListeners.add(valueChangeListener);
    }

    public void fireValueChangeListener(Object oldValue, Object newValue) {
        if (!JKObjectUtil.equals(oldValue, newValue)) {
            for (ValueChangeListener valueChangeListener : this.valueListeners) {
                valueChangeListener.valueChanged(oldValue, newValue);
            }
        }
    }

    private String getComponentName() {
        return this.comp.getName() == null ? "" : this.comp.getName();
    }

    public int getValidatorIndex(Validator validator) {
        for (int i = 0; i < this.validators.size(); ++i) {
            Validator v = this.validators.get(i);
            if (!v.getClass().getName().equals(validator.getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        if (this.comp instanceof JComponent) {
            JComponent com = (JComponent)((Object)this.comp);
            com.setComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        }
        this.comp.addFocusListener(new FocusListener(){
            private Object oldValue;

            @Override
            public void focusGained(FocusEvent e) {
                this.oldValue = FSAbstractComponent.this.comp.getValue();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Object newValue = FSAbstractComponent.this.comp.getValue();
                FSAbstractComponent.this.fireValueChangeListener(this.oldValue, newValue);
            }
        });
    }

    public void removeValidator(FSValidators validator) {
        int validatorIndex = this.getValidatorIndex(validator);
        if (validatorIndex != -1) {
            this.validators.remove(validatorIndex);
        }
    }

    private void setBorder(Border border) {
        if (this.originalBorder == null) {
            this.originalBorder = border;
        }
    }

    private void setTooltipText(String toolTipText) {
        if (this.originalTooltip == null) {
            this.originalTooltip = toolTipText;
        }
    }

    public void validateValue() throws UIValidationException {
        this.setBorder(this.comp.getBorder());
        this.setTooltipText(this.comp.getToolTipText());
        Problems problems = new Problems();
        for (Validator val : this.validators) {
            val.validate(problems, JKMessage.get(this.getComponentName(), new Object[0]), this.comp.getValue());
        }
        if (!problems.isEmpty()) {
            throw new UIValidationException(this.comp, problems);
        }
        this.comp.setBorder(this.originalBorder);
        this.comp.setToolTipText(this.originalTooltip);
    }
}

