/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.comp.JKDate;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.JKTime;
import com.jk.desktop.swing.comp.panels.JKBlobPanel;
import com.jk.desktop.validation.exception.UIValidationException;
import com.jk.locale.JKMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class SwingValidator {
    public static void checkEmpty(BindingComponent comp) {
        Object value;
        if (comp instanceof JTextComponent) {
            JTextComponent txt = (JTextComponent)((Object)comp);
            txt.setText(txt.getText().trim());
            if (txt.getText().equals("")) {
                comp.requestFocus();
                throw new UIValidationException("ERROR_EMPTY_FIELD", comp);
            }
        } else if (comp instanceof JTextArea) {
            JTextArea txt = (JTextArea)((Object)comp);
            if (txt.getText().trim().equals("")) {
                comp.requestFocus();
                throw new UIValidationException("ERROR_SELECT_ENTRY_FROM_LIST", comp);
            }
        } else if (comp instanceof JComboBox) {
            JComboBox combo = (JComboBox)((Object)comp);
            if (combo.getSelectedIndex() < 0) {
                comp.requestFocus();
                throw new UIValidationException("ERROR_SELECT_ENTRY_FROM_LIST", comp);
            }
        } else if (comp instanceof JKBlobPanel) {
            JKBlobPanel pnl = (JKBlobPanel)comp;
            if (pnl.getValue() == null) {
                pnl.requestFocus();
                throw new UIValidationException("EMPTY_IMAGE_IS_NOT_ALLOWED", comp);
            }
        } else if (comp instanceof JList) {
            JList list = (JList)((Object)comp);
            if (list.getSelectedIndex() < 0) {
                comp.requestFocus();
                throw new UIValidationException("ERROR_SELECT_ENTRY_FROM_LIST", comp);
            }
        } else if (comp instanceof JKTime) {
            ((JKTime)comp).checkValue();
        } else if (comp instanceof JKDate) {
            ((JKDate)comp).checkValue();
        } else if (comp instanceof BindingComponent && ((value = comp.getValue()) == null || value.toString().equals(""))) {
            throw new UIValidationException("ERROR_EMPTY_FIELD", comp);
        }
    }

    public static void checkValidFile(String fileName) throws UIValidationException {
        File file = new File(fileName);
        if (file.exists()) {
            throw new UIValidationException("FILE_ALREADY_EXISTS");
        }
        try {
            new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UIValidationException("FILE_NAME_IS_NOT_CORRECT");
        }
    }

    public static void checkValidInteger(JKTextField txt) throws UIValidationException {
        txt.setText(txt.getText().trim());
        try {
            Integer.parseInt(txt.getText());
        }
        catch (NumberFormatException ex) {
            txt.requestFocus();
            throw new UIValidationException("ERROR_MESSAGE_NUMERIC_EXPECTED", (BindingComponent)txt);
        }
    }

    public static void checkValidRange(JKTextField txt, float rangeFrom, float rangeTo) throws UIValidationException {
        float value = Float.parseFloat(txt.getText());
        if (!(value >= rangeFrom) || !(value <= rangeTo)) {
            txt.requestFocus();
            throw new UIValidationException(JKMessage.get("VALUE_OUT_OF_RANGE", new Object[0]) + "\n" + (int)rangeFrom + "-" + (int)rangeTo, (BindingComponent)txt);
        }
    }
}

