/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.swing;

import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKFrame;
import com.jk.desktop.swing.comp.JKInternalFrame;
import com.jk.desktop.swing.comp.JKScrollPane;
import com.jk.desktop.swing.comp.JKTable;
import com.jk.desktop.swing.comp.JKTextArea;
import com.jk.desktop.swing.comp.panels.JKImagePanel;
import com.jk.desktop.swing.comp.panels.JKMainPanel;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.dialogs.JKDialog;
import com.jk.desktop.util.ImageUtil;
import com.jk.desktop.util.JKColors;
import com.jk.exceptions.JKException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.util.JKIOUtil;
import com.jk.util.JKObjectUtil;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class SwingUtility {
    static JKLogger logger = JKLoggerFactory.getLogger(SwingUtility.class);
    static Color defaultBackgroundColor;
    static JKFrame defaultMainFrame;
    static JDialog emptyDialog;
    static ComponentOrientation defaultComponentOrientation;
    static String defaultLocale;
    private static JFileChooser chooser;
    private static Font DEFAULT_TITLE_FONT;
    private static final Font DEFAULT_TITLE_RIGHT_FONT;
    private static final Border DEFAULT_EMPTY_BORDER;
    private static final Border DEFAULT_EMPTY_SELECTED_BORDER;

    public static void addActionListener(AbstractButton btn, final Object obj, final String methodName) {
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JKObjectUtil.callMethod(obj, methodName, new Object[0]);
                }
                catch (InvocationTargetException e1) {
                    JKExceptionUtil.handle(e1.getCause());
                }
            }
        });
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static void addFocusBackKey(int button) {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Set<AWTKeyStroke> oldBackKeys = manager.getDefaultFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> backwordKeys = new HashSet<AWTKeyStroke>(oldBackKeys);
        backwordKeys.add(KeyStroke.getKeyStroke(button, 0));
        manager.setDefaultFocusTraversalKeys(1, backwordKeys);
    }

    public static void addFocusForwardKey(int button) {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Set<AWTKeyStroke> forwardKeys = manager.getDefaultFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(button, 0));
        manager.setDefaultFocusTraversalKeys(0, newForwardKeys);
    }

    private static void addPanelToDialog(JDialog dialog, JPanel panel, String title) throws HeadlessException {
        dialog.add(new JKScrollPane(panel));
        panel.setOpaque(true);
        dialog.applyComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        panel.grabFocus();
    }

    public static void addPanelToFrame(JFrame frame, JPanel panel, String title) throws HeadlessException {
        frame.add(panel);
        frame.setTitle(title);
        frame.applyComponentOrientation(SwingUtility.getDefaultComponentOrientation());
    }

    public static JPanel buildImagePanel(byte[] image, int scaled) {
        return SwingUtility.buildImagePanel(new ByteArrayInputStream(image), scaled);
    }

    public static JPanel buildImagePanel(InputStream in, int scaled) {
        if (in == null) {
            return new JKPanel();
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(in);
            return new JKImagePanel(image, scaled);
        }
        catch (IOException ex) {
            throw new JKException(ex);
        }
    }

    public static JKImagePanel buildImagePanel(URL url, int scaled) {
        BufferedImage image = null;
        try {
            if (url != null) {
                image = SwingUtility.getImage(url);
                return new JKImagePanel(image, scaled);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new JKImagePanel();
    }

    public static int calculateTextSize(String text, int fontSize) {
        JLabel lbl = new JLabel(text);
        return (int)lbl.getPreferredSize().getWidth();
    }

    public static void closePanel(JPanel pnl) {
        SwingUtility.getDefaultMainFrame().showHomePanel();
    }

    public static void closePanelDialog(JComponent comp) {
        Container cont;
        if (comp.getRootPane() != null && (cont = comp.getRootPane().getParent()) != null && cont instanceof JDialog) {
            ((JDialog)cont).dispose();
        }
    }

    public static void closePanelWindow(JComponent comp) {
        Window window;
        if (comp.getRootPane() != null && (window = SwingUtility.getWindow(comp)) != null) {
            window.dispose();
        }
    }

    public static String colorToHex(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static BufferedImage convertPanelToImage(JKPanel<?> pnl, int width, int height) {
        try {
            BufferedImage img = ImageUtil.getCompatibleImage(pnl.getWidth(), pnl.getHeight());
            Robot robot = new Robot();
            img = robot.createScreenCapture(SwingUtility.getDefaultMainFrame().getBounds());
            img = ImageUtil.scaleNewerWay(img, false, width, height);
            return img;
        }
        catch (AWTException aWTException) {
            return null;
        }
    }

    public static void createLineBorder(JKPanel<?> pnl) {
        pnl.setBorder(new LineBorder(Color.lightGray));
    }

    public static Border createTitledBorder(String title) {
        TitledBorder b = BorderFactory.createTitledBorder("");
        b.setTitle(JKMessage.get(title, true));
        b.setTitleJustification(0);
        b.setTitlePosition(2);
        b.setTitleColor(JKColors.TITLE_BORDER_BG);
        return b;
    }

    public static void enableContainer(Container cont, boolean enable) {
        int count = cont.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JPanel || comp instanceof Box) {
                SwingUtility.enableContainer((Container)comp, enable);
                continue;
            }
            if (comp instanceof JTextField) {
                ((JTextField)comp).setEnabled(enable);
                continue;
            }
            if (comp instanceof JLabel) continue;
            comp.setEnabled(enable);
        }
    }

    public static BindingComponent findBindingComponent(Container cont, String componentNam) {
        Vector<BindingComponent> components = SwingUtility.findBindingComponents(cont);
        for (BindingComponent bindingComponent : components) {
            if (bindingComponent.getName() == null || !bindingComponent.getName().equals(componentNam)) continue;
            return bindingComponent;
        }
        return null;
    }

    public static Vector<BindingComponent> findBindingComponents(Container cont) {
        Component[] components;
        Vector<BindingComponent> c = new Vector<BindingComponent>();
        for (Component component : components = cont.getComponents()) {
            if (component instanceof BindingComponent) {
                c.add((BindingComponent)((Object)component));
            }
            if (!(component instanceof Container)) continue;
            c.addAll(SwingUtility.findBindingComponents((Container)component));
        }
        return c;
    }

    public static String fixTwoLinesIssue(String str) {
        String[] arr = str.split(" ");
        String result = "<html><body>" + arr[0];
        for (int i = 1; i < arr.length; ++i) {
            result = result + "<br>" + arr[i];
        }
        result = result + "</body></html>";
        return result;
    }

    private static Window getActiveWindow() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getActiveWindow();
        if (window == null) {
            return SwingUtility.getDefaultMainFrame();
        }
        return window;
    }

    public static String getDatePattern() {
        return SwingUtility.isLeftOrientation() ? "yyyy/MM/dd" : "dd/MM/yyyy";
    }

    public static Color getDefaultBackgroundColor() {
        return defaultBackgroundColor;
    }

    public static ComponentOrientation getDefaultComponentOrientation() {
        return defaultComponentOrientation;
    }

    public static JFileChooser getDefaultFileChooser() {
        return chooser;
    }

    public static Locale getDefaultLocale() {
        return new Locale(defaultLocale, "JO");
    }

    public static JKFrame getDefaultMainFrame() {
        if (defaultMainFrame == null) {
            return new JKFrame();
        }
        return defaultMainFrame;
    }

    private static JScrollPane getDialogViewComponent(String string) {
        return SwingUtility.getDialogViewComponent(string, false);
    }

    private static JScrollPane getDialogViewComponent(String string, boolean color) {
        JKTextArea txt = new JKTextArea();
        txt.setText(JKMessage.get(string, false));
        txt.setEditable(false);
        if (color) {
            txt.setForeground(Color.red);
            txt.setFont(new Font("Tahoma", 1, 22));
        }
        JScrollPane jScrollPane = new JScrollPane(txt);
        jScrollPane.getViewport().setPreferredSize(new Dimension(500, 200));
        return jScrollPane;
    }

    public static JDialog getEmptyDialog() {
        return emptyDialog;
    }

    public static JFileChooser getFileChooser() {
        return chooser;
    }

    public static JPanel getHomePanel() {
        return SwingUtility.getDefaultMainFrame().getHomePanel();
    }

    public static BufferedImage getImage(InputStream in) throws IOException {
        BufferedImage image = ImageIO.read(in);
        return image;
    }

    public static BufferedImage getImage(String imageName) {
        try {
            return SwingUtility.getImage(JKIOUtil.getInputStream(imageName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage getImage(URL url) throws IOException {
        return ImageIO.read(url);
    }

    public static Dimension getMaxWindowSize() {
        Dimension d = SwingUtility.getScreenDimesion();
        return new Dimension((int)d.getWidth() - 100, (int)d.getHeight() - 100);
    }

    public static Dimension getScreenDimesion() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static int getTabPaneLeadingPlacement() {
        return SwingUtility.isLeftOrientation() ? 2 : 4;
    }

    public static int getTextWidth(String text, boolean bold) {
        Font font = UIManager.getFont("Label.font");
        if (bold) {
            font = font.deriveFont(1);
        }
        return SwingUtility.getTextWidth(text, font);
    }

    public static int getTextWidth(String text, Font font) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        int textwidth = (int)font.getStringBounds(text, frc).getWidth();
        int textheight = (int)font.getStringBounds(text, frc).getHeight();
        return textwidth;
    }

    private static Window getWindow(JComponent comp) {
        Container cont;
        if (comp.getRootPane() != null && (cont = comp.getRootPane().getParent()) != null && cont instanceof Window) {
            return (Window)cont;
        }
        return null;
    }

    public static Dimension getWindowActualSize(Window window) {
        Frame frame;
        if (window.isVisible()) {
            return window.getSize();
        }
        if (window instanceof Frame && (frame = (Frame)window).getExtendedState() == 6) {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        return window.getSize();
    }

    public static boolean isLeftOrientation() {
        return defaultComponentOrientation == ComponentOrientation.LEFT_TO_RIGHT;
    }

    public static boolean isVisibleOnScreen(JComponent component) {
        Window window = SwingUtility.getWindow(component);
        if (window != null) {
            return window.isVisible();
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(SwingUtility.getTextWidth("Jalal Kiswani", new Font("Arial", 1, 12)));
    }

    public static void maximumizBoth(Window window) {
        if (window instanceof Frame) {
            Frame frm = (Frame)window;
            frm.setExtendedState(6);
        } else {
            window.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    public static void packJFrameWindow(JComponent comp) {
        Container cont;
        if (comp.getRootPane() != null && (cont = comp.getRootPane().getParent()) instanceof JFrame) {
            ((JFrame)cont).pack();
            ((JFrame)cont).setLocationRelativeTo(null);
        }
    }

    public static void packWindow(JComponent comp) {
        Container cont;
        if (comp.getRootPane() != null && (cont = comp.getRootPane().getParent()) != null && cont instanceof JDialog) {
            ((JDialog)cont).pack();
            ((JDialog)cont).setLocationRelativeTo(null);
        }
    }

    public static void pressKey(int key) {
        try {
            Robot robot = new Robot();
            robot.keyPress(key);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public static void pressTab() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingUtility.pressKey(9);
            }
        };
        new Thread(r).start();
    }

    public static void printInstalledLookAndFeel() {
        UIManager.LookAndFeelInfo[] look;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : look = UIManager.getInstalledLookAndFeels()) {
            System.out.println(lookAndFeelInfo.getClassName());
        }
    }

    public static void resetComponent(Component component) {
        if (component instanceof BindingComponent) {
            ((BindingComponent)((Object)component)).reset();
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedIndex(-1);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedIndex(-1);
        } else if (component instanceof JRadioButton) {
            ((JRadioButton)component).setSelected(false);
        }
    }

    public static void resetComponent(Object component) {
        if (component instanceof BindingComponent) {
            ((BindingComponent)component).reset();
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedIndex(-1);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedIndex(-1);
        } else if (component instanceof JRadioButton) {
            ((JRadioButton)component).setSelected(false);
        }
    }

    public static void resetComponents() {
    }

    public static void setBoldFont(Component comp) {
        comp.setFont(new Font("Tahoma", 1, 10));
    }

    public static void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        SwingUtility.defaultBackgroundColor = defaultBackgroundColor;
    }

    public static void setDefaultComponentOrientation(ComponentOrientation orientation) {
        defaultComponentOrientation = orientation;
        defaultLocale = !SwingUtility.isLeftOrientation() ? "ar" : "en";
    }

    public static void setDefaultLocale(String defaultLocale) {
        if (defaultLocale.equals("ar")) {
            SwingUtility.setDefaultComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            SwingUtility.setDefaultComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        SwingUtility.defaultLocale = defaultLocale;
    }

    public static void setDefaultMainFrame(JKFrame defaultMainFrame) {
        SwingUtility.defaultMainFrame = defaultMainFrame;
        defaultMainFrame.setLocale(SwingUtility.getDefaultLocale());
    }

    public static void setFont(Component comp) {
    }

    public static void setHomePanel(JPanel homePanel) {
        SwingUtility.getDefaultMainFrame().setHomePanel(homePanel);
    }

    public static void setHotKeyFoButton(final AbstractButton btn, String keyStroke, String actionName) {
        ActionMap amap = btn.getActionMap();
        amap.put(actionName, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (btn.isVisible() && btn.isEnabled()) {
                    btn.doClick();
                }
            }
        });
        InputMap imap = btn.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(keyStroke), actionName);
    }

    public static void setHotKeyFoButton(JKButton btn, String shortcut) {
        SwingUtility.setHotKeyFoButton(btn, shortcut, shortcut);
    }

    public static void setHotKeyForFocus(final JComponent comp, String keyStroke, String actionName) {
        ActionMap amap = comp.getActionMap();
        amap.put(actionName, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                comp.requestFocus();
            }
        });
        InputMap imap = comp.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(keyStroke), actionName);
    }

    public static boolean showConfirmationDialog(JDialog dialog, String message) {
        int choice = JOptionPane.showConfirmDialog(dialog, JKMessage.get(message, true), JKMessage.get("WARNING", new Object[0]), 0);
        return choice == 0;
    }

    public static boolean showConfirmationDialog(String message) {
        return SwingUtility.showConfirmationDialog(SwingUtility.getActiveWindow(), message);
    }

    public static boolean showConfirmationDialog(String[] message) {
        return SwingUtility.showConfirmationDialog(SwingUtility.getActiveWindow(), message);
    }

    public static boolean showConfirmationDialog(String key, String extraInfo) {
        String str = JKMessage.get(key, true);
        return SwingUtility.showConfirmationDialog(str + "\n" + extraInfo);
    }

    public static boolean showConfirmationDialog(Window window, String message) {
        String no = JKMessage.get("No", new Object[0]);
        String yes = JKMessage.get("Yes", new Object[0]);
        int selection = JOptionPane.showOptionDialog(window, JKMessage.get(message, new Object[0]), JKMessage.get("WARNING", new Object[0]), 0, 3, null, new String[]{yes, no}, no);
        return selection == 0;
    }

    public static boolean showConfirmationDialog(Window window, String[] messages) {
        StringBuffer concateMessage = new StringBuffer();
        String stringLabel = "";
        for (String message : messages) {
            concateMessage.append(JKMessage.get(message, true));
            concateMessage.append("\n");
        }
        concateMessage.append("");
        int choice = JOptionPane.showConfirmDialog(window, JKMessage.get(concateMessage.toString(), true), JKMessage.get("WARNING", new Object[0]), 0);
        return choice == 0;
    }

    public static void showDatabaseErrorDialog(JDialog dialog, String message, Exception ex) {
        JOptionPane.showMessageDialog(dialog, SwingUtility.getDialogViewComponent(message));
        throw new RuntimeException(ex);
    }

    public static void showDatabaseErrorDialog(String message, Exception ex) {
        SwingUtility.showDatabaseErrorDialog(emptyDialog, message, ex);
    }

    public static void showEncodedComponent(String xml, String title) {
        if (xml == null || xml.trim().equals("")) {
            return;
        }
        Object object = JKObjectUtil.toObject(xml);
        if (object instanceof Window) {
            Window window = (Window)object;
            window.pack();
            SwingUtility.enableContainer(window, false);
            window.setVisible(true);
        } else if (object instanceof JPanel) {
            JPanel panel = (JPanel)object;
            SwingUtility.enableContainer(panel, false);
            SwingUtility.showPanelInDialog(panel, title);
        } else if (object instanceof JComponent) {
            JKPanel pnl = new JKPanel((JComponent)object);
            SwingUtility.enableContainer(pnl, false);
            SwingUtility.showPanelInDialog(pnl, title);
        } else {
            System.err.println(object.getClass().getName() + " cannot be viewed");
        }
    }

    public static void showErrorDialog(String message, Throwable ex) {
        SwingUtility.showErrorDialog(message, ex, SwingUtility.getActiveWindow());
    }

    public static void showErrorDialog(String message, Throwable ex, boolean color) {
        SwingUtility.showErrorDialog(message, ex, SwingUtility.getActiveWindow(), color);
    }

    public static void showErrorDialog(String error, Throwable e, Window parent) {
        JOptionPane.showMessageDialog(parent, SwingUtility.getDialogViewComponent(error));
        throw new RuntimeException(e);
    }

    public static void showErrorDialog(String error, Throwable e, Window parent, boolean color) {
        JOptionPane.showMessageDialog(parent, SwingUtility.getDialogViewComponent(error, true));
        throw new RuntimeException(e);
    }

    public static void showFrame(String frameClassName, JDesktopPane pane) throws InstantiationException, IllegalAccessException, ClassNotFoundException, PropertyVetoException {
        if (frameClassName != null && !frameClassName.trim().equals("")) {
            Object instance = Class.forName(frameClassName).newInstance();
            if (instance instanceof JFrame) {
                JFrame frame = (JFrame)instance;
                if (!frame.isVisible()) {
                    frame.setExtendedState(6);
                    frame.setVisible(true);
                }
            } else if (instance instanceof JKInternalFrame) {
                JKInternalFrame frm = (JKInternalFrame)instance;
                pane.add(frm);
                if (!frm.isVisible()) {
                    frm.initDefaults();
                }
            } else {
                System.err.println(frameClassName + " is not instanceof JFrame");
            }
        }
    }

    public static String showInputDialog(Component parentComponent, String message) throws HeadlessException {
        return JOptionPane.showInputDialog(parentComponent, (Object)JKMessage.get(message, true));
    }

    public static String showInputDialog(String message) throws HeadlessException {
        return SwingUtility.showInputDialog(defaultMainFrame, message);
    }

    public static int showIntegerInput(String msg) {
        String input;
        while ((input = SwingUtility.showInputDialog(msg)) != null) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                SwingUtility.showUserErrorDialog("PLEASE_ENTER_NUMBERS_ONLY", false);
            }
        }
        return -1;
    }

    public static void showMessageDialog(String message, Throwable ex) {
        JOptionPane.showMessageDialog(SwingUtility.getActiveWindow(), JKMessage.get(message, false));
        throw new RuntimeException(message, ex);
    }

    public static JKFrame showPanelFrame(JKPanel<?> panel, String title) {
        JKFrame frame = new JKFrame(title);
        frame.add(panel, "Center");
        frame.pack();
        frame.setExtendedState(6);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        return frame;
    }

    public static JDialog showPanelInDialog(JPanel panel, String title) {
        return SwingUtility.showPanelInDialog(panel, title, true);
    }

    public static JDialog showPanelInDialog(JPanel pnl, String title, boolean modal) {
        return SwingUtility.showPanelInDialog(pnl, title, modal, null);
    }

    public static JKDialog showPanelInDialog(JPanel pnl, String title, boolean modal, JKPanel<?> parent) {
        return SwingUtility.showPanelInDialog(pnl, title, modal, parent, null);
    }

    public static JKDialog showPanelInDialog(JPanel pnl, String title, boolean modal, JKPanel<?> parent, Dimension dimension) {
        Container cont;
        Dialog dialog = null;
        if (parent != null && parent.getRootPane() != null && (cont = parent.getRootPane().getParent()) != null && cont instanceof JDialog) {
            dialog = new JKDialog((Window)((JDialog)cont), title);
        }
        if (dialog == null) {
            dialog = new JKDialog(SwingUtility.getActiveWindow(), title);
        }
        dialog.setResizable(true);
        SwingUtility.addPanelToDialog((JDialog)dialog, pnl, title);
        if (dimension != null) {
            dialog.setSize(dimension);
        } else {
            dialog.pack();
        }
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setModal(modal);
        dialog.setVisible(true);
        return dialog;
    }

    public static void showSuccessDialog(JDialog parent, String string) {
        JOptionPane.showMessageDialog(parent, JKMessage.get(string, true));
    }

    public static void showSuccessDialog(String string) {
        JOptionPane.showMessageDialog(SwingUtility.getActiveWindow(), SwingUtility.getDialogViewComponent(string));
    }

    public static void showUserErrorDialog(Window parent, String message, Exception ex) {
        JOptionPane.showMessageDialog(parent, SwingUtility.getDialogViewComponent(message));
    }

    public static void showUserErrorDialog(String string) {
        SwingUtility.showUserErrorDialog(string, true);
    }

    public static void showUserErrorDialog(String string, boolean throwRuntimeException) {
        JScrollPane jScrollPane = SwingUtility.getDialogViewComponent(string);
        JOptionPane.showMessageDialog(SwingUtility.getActiveWindow(), jScrollPane);
        if (throwRuntimeException) {
            throw new RuntimeException(string);
        }
    }

    public static void showUserErrorDialog(String message, Exception ex) {
        SwingUtility.showUserErrorDialog(SwingUtility.getActiveWindow(), message, ex);
        throw new RuntimeException(message);
    }

    public static void showUserErrorDialog(String messge, String extraInfo) {
        String str = JKMessage.get(messge, true);
        SwingUtility.showUserErrorDialog(str + "\n" + extraInfo);
    }

    public static void testComponentSerialization(Object obj) {
        String xml = JKObjectUtil.toXml(obj);
        SwingUtility.showEncodedComponent(xml, "Test");
    }

    public static void testInternalFrame(JKInternalFrame frame) {
        JKFrame frm = new JKFrame();
        frm.setExtendedState(6);
        frm.add(new JKPanel(frame));
        try {
            frame.initDefaults();
            frm.setVisible(true);
        }
        catch (PropertyVetoException e) {
            JKExceptionUtil.handle(e);
        }
    }

    public static void testPanel(JPanel panel) {
        JKFrame frame = new JKFrame();
        JKMainPanel mainPanel = new JKMainPanel(new BorderLayout());
        mainPanel.add(panel);
        frame.add(mainPanel);
        frame.applyComponentOrientation(SwingUtility.getDefaultComponentOrientation());
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static BufferedImage toBufferedImage(byte[] imageBytes) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(imageBytes));
    }

    public static Color hexToColor(String colorHex) {
        String replace = colorHex.replace("#", "0x");
        return Color.decode(replace);
    }

    public static Font getDefaultTitleFont() {
        if (SwingUtility.isLeftOrientation()) {
            return DEFAULT_TITLE_FONT;
        }
        return DEFAULT_TITLE_RIGHT_FONT;
    }

    public static Border getDefaultEmptyBorder() {
        return DEFAULT_EMPTY_BORDER;
    }

    public static Border getDefaultEmptySelectedBorder() {
        return DEFAULT_EMPTY_SELECTED_BORDER;
    }

    public static Icon getIcon(String iconName) {
        if (iconName == null || iconName.equals("")) {
            return null;
        }
        URL iconURL = SwingUtility.getIconURL(iconName);
        if (iconURL == null) {
            System.err.println("Icon " + iconName + " not found , URL : " + iconURL);
            return null;
        }
        return new ImageIcon(iconURL);
    }

    public static URL getIconURL(String fileName) {
        URL url = JKIOUtil.getURL("/resources/icons/".concat(fileName));
        return url;
    }

    public static void showTableInDialog(JKTable table, String title) {
        JKPanel pnl = new JKPanel(new BorderLayout());
        pnl.add(new JScrollPane(table));
        SwingUtility.showPanelInDialog(pnl, title);
    }

    static {
        try {
            if (SwingUtility.isWindows()) {
                UIManager.setLookAndFeel((LookAndFeel)((Object)new WindowsLookAndFeel()));
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            if (JKObjectUtil.isClassAvilableInClassPath("org.eclipse.swt.SWT")) {
                NativeInterface.open();
            }
            logger.debug("Set lookAndFeel as : ", UIManager.getLookAndFeel());
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
        defaultBackgroundColor = JKColors.MAIN_PANEL_BG;
        emptyDialog = new JDialog();
        defaultComponentOrientation = ComponentOrientation.LEFT_TO_RIGHT;
        defaultLocale = "en";
        chooser = new JFileChooser(".");
        DEFAULT_TITLE_FONT = UIManager.getDefaults().getFont("TabbedPane.font").deriveFont(16.0f);
        DEFAULT_TITLE_RIGHT_FONT = UIManager.getDefaults().getFont("TabbedPane.font");
        DEFAULT_EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
        DEFAULT_EMPTY_SELECTED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), DEFAULT_EMPTY_BORDER);
    }
}

