/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.util;

import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.util.JKIOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcUtil {
    public static byte[] getBinaryStream(ResultSet rs, String name) throws SQLException {
        InputStream in = rs.getBinaryStream(name);
        if (in == null) {
            return null;
        }
        return JKIOUtil.readStream(in);
    }

    public static byte[] getBlobColumn(ResultSet rs, String columnName) throws SQLException {
        try {
            Blob blob = rs.getBlob(columnName);
            if (blob == null) {
                return null;
            }
            InputStream is = blob.getBinaryStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (is == null) {
                return null;
            }
            byte[] buffer = new byte[64];
            int c = is.read(buffer);
            while (c > 0) {
                bos.write(buffer, 0, c);
                c = is.read(buffer);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new SQLException("Failed to read BLOB column due to IOException: " + e.getMessage());
        }
    }

    public static Properties getJdbcDrivers() {
        return JKIOUtil.readPropertiesFile("drivers.properties");
    }

    public static void main(String[] args) {
        System.out.println(JdbcUtil.getJdbcDrivers());
    }

    public static void ping(String driver, String url, String user, String password) {
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, user, password);
            connection.close();
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }
}

