/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.paging;

import com.jk.db.dataaccess.plain.JKPlainDataAccess;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.db.dynamic.paging.DataPager;
import com.jk.db.dynamic.paging.PagingException;
import com.jk.util.JKDebugUtil;
import javax.sql.rowset.CachedRowSet;

public class DataBasePager
implements DataPager {
    private String query;
    private int pageRowsCount = -1;
    private int pagesCount;
    private int currentPage;
    private int allRowsCount;
    JKDataSource datasource;
    JKPlainDataAccess dataAccess = JKDataSourceFactory.getPlainDataAccess();
    private CachedRowSet resultSet;

    public static void main(String[] args) {
        DataBasePager p = new DataBasePager();
        p.setQuery("SELECT * FROM GEN_NATIONAL_NUMBERS");
        JKDebugUtil.printCurrentTime(1);
        System.out.println(p.getAllRowsCount());
        JKDebugUtil.printCurrentTime(2);
        System.out.println(p.getPagesCount());
        JKDebugUtil.printCurrentTime(3);
        p.moveToFirstPage();
        JKDebugUtil.printCurrentTime(4);
        p.moveToNextPage();
        JKDebugUtil.printCurrentTime(5);
        p.moveToNextPage();
        JKDebugUtil.printCurrentTime(6);
        p.moveToNextPage();
        JKDebugUtil.printCurrentTime(7);
    }

    @Override
    public int getAllRowsCount() {
        return this.allRowsCount;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int getPageRowsCount() {
        return this.pageRowsCount == -1 ? JKDataSourceFactory.getDefaultDataSource().getQueryLimit() : this.pageRowsCount;
    }

    @Override
    public int getPagesCount() {
        return this.pagesCount;
    }

    public String getQuery() {
        return this.query;
    }

    public CachedRowSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void moveToFirstPage() throws PagingException {
        boolean currentPage = false;
        this.moveToPage(0);
    }

    @Override
    public void moveToLastPage() throws PagingException {
        this.moveToPage(this.getPagesCount() - 1);
    }

    @Override
    public void moveToNextPage() throws PagingException {
        this.moveToPage(this.currentPage + 1);
    }

    @Override
    public void moveToPage(int page) {
        if (page >= 0 && page < this.getPagesCount()) {
            try {
                this.resultSet = this.pagesCount == 1 ? this.dataAccess.executeQueryAsCachedRowSet(this.query, new Object[0]) : this.dataAccess.executeQueryAsCachedRowSet(this.query, page * this.getPageRowsCount(), page * this.getPageRowsCount() + this.getPageRowsCount());
                this.currentPage = page;
            }
            catch (Exception e) {
                throw new PagingException(e);
            }
        } else {
            this.resultSet = null;
        }
    }

    @Override
    public void moveToPreviousePage() throws PagingException {
        this.moveToPage(this.currentPage - 1);
    }

    public void setDatasource(JKDataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public void setPageRowsCount(int pageRowsCount) {
        this.pageRowsCount = pageRowsCount;
    }

    public void setQuery(String query) {
        this.query = query;
        if (this.getPageRowsCount() == 0) {
            this.pagesCount = 1;
        } else {
            this.allRowsCount = this.dataAccess.getRowsCount(query, new Object[0]);
            if (this.allRowsCount <= this.getPageRowsCount()) {
                this.pagesCount = 1;
            } else {
                this.pagesCount = this.allRowsCount / this.getPageRowsCount();
                if (this.allRowsCount % this.getPageRowsCount() > 0) {
                    ++this.pagesCount;
                }
            }
        }
        this.moveToPage(this.getCurrentPage());
    }
}

