/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.oracle;

import com.jk.db.dataaccess.oracle.OracleAbstractDao;
import com.jk.db.dataaccess.plain.JKUpdater;
import com.jk.db.dynamic.DynamicDao;
import com.jk.metadata.db.meta.Record;
import com.jk.metadata.db.meta.TableMeta;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

public class OracleDynamicDao
extends DynamicDao {
    private final OracleAbstractDao oracleDao = new OracleAbstractDao();

    public OracleDynamicDao(String tableMetaName) {
        super(tableMetaName);
    }

    public OracleDynamicDao(TableMeta meta) {
        super(meta);
    }

    @Override
    protected int getGeneratedKeys(PreparedStatement ps) throws SQLException {
        throw new IllegalStateException("getGeneratedKeys not implemented on oracle DBMS");
    }

    @Override
    public Date getSystemDate() {
        return this.oracleDao.getSystemDate();
    }

    @Override
    public String insertRecord(final Record record) {
        if (record.getIdValue() == null) {
            long nextId = this.oracleDao.getNextId(this.tableMeta.getTableName(), record.getIdField().getFieldName());
            record.setIdValue(nextId);
        }
        this.callBeforeAddEventOnTriggers(record);
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return OracleDynamicDao.this.sqlBuilder.buildInsert(record);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
                OracleDynamicDao.this.setParamters(record, ps, true);
            }
        };
        this.executeUpdate(updater);
        this.callAfterAddEventOnTriggers(record);
        return record.getIdValue().toString();
    }
}

