/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta.xml;

import com.jk.db.dynamic.meta.xml.JKXmlException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.constraints.Constraint;
import com.jk.metadata.db.constraints.DataRangeConstraint;
import com.jk.metadata.db.constraints.DuplicateDataConstraint;
import com.jk.metadata.db.constraints.IdenticalFieldsContraint;
import com.jk.metadata.db.constraints.LessThanContsraint;
import com.jk.metadata.db.meta.FieldGroup;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.metadata.db.trigger.FieldTrigger;
import com.jk.util.JKValidationUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableMetaXmlParser {
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) throws JKXmlException {
    }

    public Hashtable<String, TableMeta> parse(InputStream in, String source) throws JKXmlException {
        this.logger.debug("parsing tablemeta for source : " + source);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList tablesNode = doc.getElementsByTagName("table");
            Hashtable<String, TableMeta> tablesHash = new Hashtable<String, TableMeta>();
            for (int i = 0; i < tablesNode.getLength(); ++i) {
                Element table = (Element)tablesNode.item(i);
                TableMeta tableInstance = (TableMeta)TableMeta.class.newInstance();
                tableInstance.setTableName(table.getAttribute("name"));
                this.logger.debug("parsing table : " + tableInstance.getTableName());
                tableInstance.setSource(source);
                if (!table.getAttribute("id").equals("")) {
                    tableInstance.setTableId(table.getAttribute("id"));
                }
                if (!table.getAttribute("max-records_count").equals("")) {
                    tableInstance.setMaxRecordsCount(Integer.parseInt(table.getAttribute("max-records_count")));
                }
                if (!table.getAttribute("icon-image").equals("")) {
                    tableInstance.setIconName(table.getAttribute("icon-image"));
                }
                if (!table.getAttribute("caption").equals("")) {
                    tableInstance.setCaption(table.getAttribute("caption"));
                }
                if (!table.getAttribute("allow-manage").equals("")) {
                    tableInstance.setAllowManage(Boolean.parseBoolean(table.getAttribute("allow-manage")));
                }
                if (!table.getAttribute("page-row-count").equals("")) {
                    tableInstance.setPageRowCount(Integer.parseInt(table.getAttribute("page-row-count")));
                }
                if (!table.getAttribute("filter-indices").equals("")) {
                    tableInstance.setFilters(table.getAttribute("filter-indices").split(","));
                }
                if (!table.getAttribute("ui-colunm-count").equals("")) {
                    tableInstance.setDefaultUIRowCount(Integer.parseInt(table.getAttribute("ui-colunm-count")));
                }
                if (!table.getAttribute("ui-row-count").equals("")) {
                    tableInstance.setDefaultUIRowCount(Integer.parseInt(table.getAttribute("ui-row-count")));
                }
                if (!table.getAttribute("panel-class").equals("")) {
                    tableInstance.setPanelClassName(table.getAttribute("panel-class"));
                }
                if (!table.getAttribute("manage-panel-class").equals("")) {
                    tableInstance.setManagePanelClassName(table.getAttribute("manage-panel-class"));
                }
                if (!table.getAttribute("allow-delete").equals("")) {
                    tableInstance.setAllowDelete(Boolean.parseBoolean(table.getAttribute("allow-delete")));
                }
                if (!table.getAttribute("allow-update").equals("")) {
                    tableInstance.setAllowUpdate(Boolean.parseBoolean(table.getAttribute("allow-update")));
                }
                if (!table.getAttribute("allow-add").equals("")) {
                    tableInstance.setAllowAdd(Boolean.parseBoolean(table.getAttribute("allow-add")));
                }
                if (!table.getAttribute("class").equals("")) {
                    tableInstance.setBeanName(table.getAttribute("class"));
                }
                this.parseGroup(table, tableInstance);
                for (int j = 0; j < table.getChildNodes().getLength(); ++j) {
                    Node node = table.getChildNodes().item(j);
                    if (node.getNodeName().equals("group")) {
                        this.parseGroup((Element)node, tableInstance);
                        continue;
                    }
                    if (node.getNodeName().equals("constraints")) {
                        ArrayList<Constraint> constraints = this.parseConstraints(tableInstance, node);
                        tableInstance.setConstraints(constraints);
                        continue;
                    }
                    if (node.getNodeName().equals("report-sql")) {
                        tableInstance.setReportSql(node.getTextContent().trim());
                        continue;
                    }
                    if (node.getNodeName().equals("short-sql")) {
                        tableInstance.setShortReportSql(node.getTextContent().trim());
                        continue;
                    }
                    if (node.getNodeName().equals("list-sql")) {
                        tableInstance.setListSql(node.getTextContent().trim());
                        continue;
                    }
                    if (!node.getNodeName().equals("triggers")) continue;
                    tableInstance.setTriggerNames(this.parseTriggers(node));
                }
                this.logger.debug("add tablemeta to hash");
                tablesHash.put(tableInstance.getTableId(), tableInstance);
            }
            return tablesHash;
        }
        catch (Exception e) {
            throw new JKXmlException(e);
        }
    }

    protected Constraint parseConstraint(TableMeta tableMeta, Element element) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Constraint instance;
        this.logger.debug("parseConstraint");
        if (!element.getAttribute("class").equals("")) {
            instance = (Constraint)Class.forName(element.getAttribute("class")).newInstance();
        } else {
            Constraint cons;
            String constType = element.getAttribute("type");
            if (constType.equals("no-duplicate")) {
                instance = (Constraint)DuplicateDataConstraint.class.newInstance();
            } else if (constType.equals("range")) {
                cons = (DataRangeConstraint)DataRangeConstraint.class.newInstance();
                cons.setValueFrom(Float.parseFloat(element.getAttribute("value-from")));
                cons.setValueTo(Float.parseFloat(element.getAttribute("value-to")));
                instance = cons;
            } else if (constType.equals("less-than")) {
                cons = (LessThanContsraint)LessThanContsraint.class.newInstance();
                instance = cons;
            } else if (constType.equals("no-idenetical")) {
                cons = (IdenticalFieldsContraint)IdenticalFieldsContraint.class.newInstance();
                instance = cons;
            } else {
                instance = (Constraint)Constraint.class.newInstance();
            }
        }
        instance.setName(element.getAttribute("name"));
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Element fieldNode;
            Node n = element.getChildNodes().item(i);
            if (!(n instanceof Element) || !(fieldNode = (Element)n).getTagName().equals("field")) continue;
            String fieldName = fieldNode.getAttribute("name");
            FieldMeta field = tableMeta.getField(fieldName);
            instance.addField(field);
        }
        instance.setTableMeta(tableMeta);
        return instance;
    }

    protected ArrayList<Constraint> parseConstraints(TableMeta tableMeta, Node constraintsNode) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.logger.debug("parseConstraint2");
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (int i = 0; i < constraintsNode.getChildNodes().getLength(); ++i) {
            Node node = constraintsNode.getChildNodes().item(i);
            if (!node.getNodeName().equals("constraint")) continue;
            Constraint cons = this.parseConstraint(tableMeta, (Element)node);
            constraints.add(cons);
        }
        return constraints;
    }

    protected FieldMeta parseField(Element element, TableMeta tableInstance) throws Exception {
        FieldMeta instance;
        this.logger.debug("parseField");
        if (!element.getAttribute("reference_table").equals("")) {
            instance = (FieldMeta)ForiegnKeyFieldMeta.class.newInstance();
            ((ForiegnKeyFieldMeta)instance).setReferenceTable(element.getAttribute("reference_table"));
            ((ForiegnKeyFieldMeta)instance).setReferenceField(element.getAttribute("reference_field"));
            if (!element.getAttribute("relation").equals("")) {
                ((ForiegnKeyFieldMeta)instance).setRelation(ForiegnKeyFieldMeta.Relation.valueOf(element.getAttribute("relation")));
            }
            if (!element.getAttribute("view-mode").equals("")) {
                ((ForiegnKeyFieldMeta)instance).setViewMode(ForiegnKeyFieldMeta.ViewMode.valueOf(element.getAttribute("view-mode")));
            }
        } else {
            instance = (FieldMeta)FieldMeta.class.newInstance();
        }
        this.parseFieldProperties(element, tableInstance, instance);
        return instance;
    }

    protected void parseFieldProperties(Element element, TableMeta tableInstance, FieldMeta instance) throws Exception {
        this.logger.debug("parseFieldProperties");
        instance.setParentTable(tableInstance);
        instance.setName(element.getAttribute("name"));
        instance.setCaption(element.getAttribute("caption"));
        if (!element.getAttribute("type").equals("")) {
            instance.setType(Integer.parseInt(element.getAttribute("type")));
        }
        if (!element.getAttribute("property").equals("")) {
            instance.setPropertyName(element.getAttribute("property"));
        }
        if (!element.getAttribute("required").equals("")) {
            instance.setRequired(Boolean.parseBoolean(element.getAttribute("required")));
        }
        if (!element.getAttribute("width").equals("")) {
            instance.setWidth(Integer.parseInt(element.getAttribute("width")));
        }
        if (!element.getAttribute("visible").equals("")) {
            instance.setVisible(Boolean.parseBoolean(element.getAttribute("visible")));
        }
        if (!element.getAttribute("allow-update").equals("")) {
            instance.setAllowUpdate(Boolean.parseBoolean(element.getAttribute("allow-update")));
        }
        if (!element.getAttribute("max-length").equals("")) {
            instance.setMaxLength(Integer.parseInt(element.getAttribute("max-length")));
        }
        if (!element.getAttribute("confirm-input").equals("")) {
            instance.setConfirmInput(Boolean.parseBoolean(element.getAttribute("confirm-input")));
        }
        if (!element.getAttribute("enabled").equals("")) {
            instance.setEnabled(Boolean.parseBoolean(element.getAttribute("enabled")));
        }
        if (!element.getAttribute("summary-field").equals("")) {
            instance.setSummaryField(Boolean.parseBoolean(element.getAttribute("summary-field")));
        }
        if (!element.getAttribute("default-value").equals("")) {
            instance.setDefaultValue(element.getAttribute("default-value"));
        }
        if (!element.getAttribute("options-query").equals("")) {
            instance.setOptionsQuery(element.getAttribute("options-query"));
        }
        if (!element.getAttribute("filtered-by").equals("")) {
            instance.setFilteredBy(element.getAttribute("filtered-by"));
        }
        if (!element.getAttribute("lookup-number").equals("")) {
            instance.setLookupNumber(Boolean.parseBoolean(element.getAttribute("lookup-number")));
        }
        if (!element.getAttribute("keep-last").equals("")) {
            instance.setKeepLastValue(Boolean.parseBoolean(element.getAttribute("keep-last")));
        }
        if (!element.getAttribute("visible-width").equals("")) {
            instance.setVisibleWidth(Integer.parseInt(element.getAttribute("visible-width")));
        }
        if (!element.getAttribute("visible-height").equals("")) {
            instance.setVisibleWidth(Integer.parseInt(element.getAttribute("visible-height")));
        }
        this.setFieldTriggers(element, instance);
    }

    protected void parseGroup(Element groupNode, TableMeta tableInstance) throws Exception {
        this.logger.debug("parseGroup");
        FieldGroup group = new FieldGroup();
        if (!groupNode.getAttribute("name").equals("")) {
            group.setName(groupNode.getAttribute("name"));
        }
        if (!groupNode.getAttribute("ui-row-count").equals("")) {
            group.setRowCount(Integer.parseInt(groupNode.getAttribute("ui-row-count")));
        }
        for (int j = 0; j < groupNode.getChildNodes().getLength(); ++j) {
            Node node = groupNode.getChildNodes().item(j);
            if (node.getNodeName().equals("id-field")) {
                IdFieldMeta id = this.parseIdField((Element)node, tableInstance);
                group.addField(id);
                continue;
            }
            if (!node.getNodeName().equals("field")) continue;
            FieldMeta field = this.parseField((Element)node, tableInstance);
            group.addField(field);
        }
        tableInstance.addGroup(group);
    }

    protected IdFieldMeta parseIdField(Element element, TableMeta tableInstance) throws Exception {
        this.logger.debug("parseIdField");
        IdFieldMeta instance = (IdFieldMeta)IdFieldMeta.class.newInstance();
        if (!element.getAttribute("auto-increment").equals("")) {
            instance.setAutoIncrement(Boolean.parseBoolean(element.getAttribute("auto-increment")));
        }
        this.parseFieldProperties(element, tableInstance, instance);
        return instance;
    }

    protected HashSet<String> parseTriggers(Node node) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.logger.debug("parse triggers");
        HashSet<String> triggers = new HashSet<String>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            String triggerClassName;
            Node n = node.getChildNodes().item(i);
            if (!n.getNodeName().equals("trigger") || JKValidationUtil.isEmpty(triggerClassName = n.getTextContent().trim())) continue;
            triggers.add(triggerClassName);
        }
        return triggers;
    }

    protected ArrayList<FieldTrigger> setFieldTriggers(Element element, FieldMeta instance) throws Exception {
        this.logger.debug("setFieldTriggers");
        ArrayList<FieldTrigger> triggers = new ArrayList<FieldTrigger>();
        NodeList nodes = element.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (!node.getNodeName().equals("triggers")) continue;
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node n = node.getChildNodes().item(i);
                if (!n.getNodeName().equals("trigger")) continue;
                String triggerClassName = node.getTextContent().trim();
                instance.addTrigger(triggerClassName);
            }
        }
        return triggers;
    }
}

