/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta.xml;

import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.constraints.Constraint;
import com.jk.metadata.db.constraints.DataRangeConstraint;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import java.util.List;

public class TableMetaXMLGenerator {
    private JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    protected Object buildConstraint(Constraint constraint) {
        StringBuffer buf = new StringBuffer();
        buf.append("<constraint ");
        buf.append("name='" + constraint.getName() + "' type='" + constraint.getTypeString() + "' ");
        if (constraint instanceof DataRangeConstraint) {
            buf.append(" value-from='" + ((DataRangeConstraint)constraint).getValueFrom() + "' ");
            buf.append(" value-to='" + ((DataRangeConstraint)constraint).getValueTo() + "' ");
        }
        buf.append(" >");
        for (int i = 0; i < constraint.getFields().size(); ++i) {
            if (constraint.getFields().get(i) == null) continue;
            buf.append("<field name='" + constraint.getFields().get(i).getName() + "' />");
        }
        buf.append("</constraint>");
        return buf;
    }

    protected void buildFieldsAttributes(FieldMeta fieldMeta, StringBuffer buf) {
        buf.append(" name='" + fieldMeta.getName() + "' ");
        if (fieldMeta.getType() != 12) {
            buf.append(" type='" + fieldMeta.getType() + "' ");
        }
        if (fieldMeta.getMaxLength() != 50) {
            buf.append(" max-length='" + fieldMeta.getMaxLength() + "' ");
        }
        if (!fieldMeta.isRequired()) {
            buf.append(" required='" + fieldMeta.isRequired() + "' ");
        }
        if (!fieldMeta.isAllowUpdate()) {
            buf.append(" allow-update='" + fieldMeta.isAllowUpdate() + "' ");
        }
        if (!fieldMeta.isVisible()) {
            buf.append(" visible='" + fieldMeta.isVisible() + "' ");
        }
        if (!fieldMeta.isEnabled()) {
            buf.append(" enabled='" + fieldMeta.isEnabled() + "'");
        }
        if (fieldMeta.getDefaultValue() != null && !fieldMeta.getDefaultValue().equals("")) {
            buf.append(" default-value='" + fieldMeta.getDefaultValue() + "'");
        }
        if (fieldMeta.isSummaryField()) {
            buf.append(" summary-field='" + fieldMeta.isSummaryField() + "'");
        }
    }

    protected String buildFieldXml(FieldMeta fieldMeta) {
        if (fieldMeta instanceof ForiegnKeyFieldMeta) {
            return this.buildForiegnKeyFieldXML((ForiegnKeyFieldMeta)fieldMeta);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<field ");
        this.buildFieldsAttributes(fieldMeta, buf);
        buf.append("/>\n");
        return buf.toString();
    }

    protected String buildForiegnKeyFieldXML(ForiegnKeyFieldMeta fieldMeta) {
        StringBuffer buf = new StringBuffer();
        buf.append("<field ");
        this.buildFieldsAttributes(fieldMeta, buf);
        buf.append(" reference_table='" + fieldMeta.getReferenceTable() + "' ");
        buf.append(" reference_field='" + fieldMeta.getReferenceField() + "' ");
        if (fieldMeta.getViewMode() != ForiegnKeyFieldMeta.DEFAULT_VIEW_MODE) {
            buf.append(" view-mode='" + fieldMeta.getViewMode() + "' ");
        }
        if (fieldMeta.getRelation() != ForiegnKeyFieldMeta.DEFAULT_RELATION) {
            buf.append(" relation='" + fieldMeta.getRelation() + "' ");
        }
        buf.append("/>\n");
        return buf.toString();
    }

    protected String buildIdFieldXML(TableMeta tableMeta) {
        StringBuffer buf = new StringBuffer();
        IdFieldMeta id = tableMeta.getIdField();
        buf.append("<id-field ");
        if (!id.isAutoIncrement()) {
            buf.append(" auto-increment='" + id.isAutoIncrement() + "' ");
        }
        this.buildFieldsAttributes(id, buf);
        buf.append("/>\n");
        return buf.toString();
    }

    protected String buildTrigger(String triggerName) {
        StringBuffer buf = new StringBuffer();
        buf.append("<trigger>");
        buf.append(triggerName);
        buf.append("</trigger>");
        return buf.toString();
    }

    protected String generateTableMetaXML(TableMeta tableMeta) {
        int i;
        this.logger.info("Generating tableMeta for table : " + tableMeta.getTableName());
        StringBuffer buf = new StringBuffer();
        buf.append("<table ");
        buf.append("name='" + tableMeta.getTableName() + "' ");
        buf.append("icon-image='" + tableMeta.getTableName() + ".png' ");
        if (!tableMeta.isTableIdNull()) {
            buf.append(" id='" + tableMeta.getTableId() + "' ");
        }
        if (tableMeta.getMaxRecordsCount() != 0) {
            buf.append(" max-records_count='" + tableMeta.getMaxRecordsCount() + "' ");
        }
        if (tableMeta.isAllowManage()) {
            buf.append(" allow-manage='" + tableMeta.isAllowManage() + "' ");
        }
        if (tableMeta.getIconName() != null) {
            buf.append(" icon-image='" + tableMeta.getIconName() + "'");
        }
        if (tableMeta.getPageRowCount() != 25) {
            buf.append(" page-row-count='" + tableMeta.getPageRowCount() + "' ");
        }
        if (!tableMeta.isCaptionNull()) {
            buf.append(" caption='" + tableMeta.getCaption() + "'");
        }
        if (tableMeta.getFilters().length > 0) {
            buf.append(" filter-indices='" + tableMeta.getFiltersAsString() + "'");
        }
        if (tableMeta.getPanelClassName() != null && !tableMeta.getPanelClassName().equals("")) {
            buf.append(" panel-class='" + tableMeta.getPanelClassName() + "'");
        }
        if (!tableMeta.isAllowAdd()) {
            buf.append(" allow-add='" + tableMeta.isAllowAdd() + "' ");
        }
        if (!tableMeta.isAllowDelete()) {
            buf.append(" allow-delete='" + tableMeta.isAllowDelete() + "' ");
        }
        if (!tableMeta.isAllowUpdate()) {
            buf.append(" allow-update='" + tableMeta.isAllowUpdate() + "' ");
        }
        if (tableMeta.getDefaultUIRowCount() != 12) {
            buf.append(" ui-colunm-count='" + tableMeta.getDefaultUIRowCount() + "' ");
        }
        buf.append(">\n");
        buf.append(this.buildIdFieldXML(tableMeta));
        for (i = 0; i < tableMeta.getFieldList().size(); ++i) {
            buf.append(this.buildFieldXml(tableMeta.getFieldList().get(i)));
        }
        if (tableMeta.getConstraints().size() > 0) {
            buf.append("<constraints>\n");
            for (i = 0; i < tableMeta.getConstraints().size(); ++i) {
                buf.append(this.buildConstraint(tableMeta.getConstraints().get(i)));
            }
            buf.append("</constraints>\n");
        }
        if (tableMeta.getTriggerNames().size() > 0) {
            buf.append("<triggers>\n");
            for (String triggerName : tableMeta.getTriggerNames()) {
                buf.append(this.buildTrigger(triggerName) + "\n");
            }
            buf.append("</triggers>\n");
        }
        if (!tableMeta.isReportSqlNull()) {
            buf.append("<report-sql>\n");
            buf.append(tableMeta.getReportSql() + "\n");
            buf.append("</report-sql>\n");
        }
        if (!tableMeta.isListSqlNull()) {
            buf.append("<list-sql>\n");
            buf.append(tableMeta.getListSql() + "\n");
            buf.append("</list-sql>\n");
        }
        if (!tableMeta.isShortSqlNull()) {
            buf.append("<short-sql>\n");
            buf.append(tableMeta.getShortReportSql() + "\n");
            buf.append("</short-sql>\n");
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public String generateTablesMetaXml(List<TableMeta> tables) {
        StringBuffer buf = new StringBuffer();
        buf.append("<tables>\n");
        for (int i = 0; i < tables.size(); ++i) {
            TableMeta tableMeta = tables.get(i);
            buf.append("<!-- ///////////////////////////////////////////////////////////////////////////// -->\n");
            buf.append("<!-- Table Meta for : -" + tableMeta.getTableName() + "-with id : -" + tableMeta.getTableId() + "- -->\n");
            buf.append("<!-- ///////////////////////////////////////////////////////////////////////////// -->\n");
            buf.append(this.generateTableMetaXML(tableMeta));
        }
        buf.append("</tables>");
        return buf.toString();
    }
}

