/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta.generator;

import com.jk.db.dataaccess.plain.JKPlainDataAccess;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.db.dynamic.meta.generator.DataBaseAnalayzer;
import com.jk.exceptions.JKDataAccessException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.CachedRowSet;

public abstract class AbstractDataBaseAnaylazer
implements DataBaseAnalayzer {
    private DatabaseMetaData meta;
    private final JKDataSource dataSource;
    private JKPlainDataAccess dao;

    public static void main(String[] args) throws JKDataAccessException, SQLException {
    }

    public AbstractDataBaseAnaylazer() {
        this(JKDataSourceFactory.getDefaultDataSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDataBaseAnaylazer(JKDataSource dataSource) {
        this.dataSource = dataSource;
        Connection connection = dataSource.getQueryConnection();
        try {
            this.meta = connection.getMetaData();
            this.dao = JKDataSourceFactory.getPlainDataAccess();
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
        finally {
            dataSource.close(connection);
        }
    }

    protected abstract String buildEmptyRowQuery(String var1, String var2);

    @Override
    public List<String> getCatalogsName() {
        try {
            ResultSet rs = this.meta.getCatalogs();
            ArrayList<String> catalogNames = new ArrayList<String>();
            boolean counter = true;
            while (rs.next()) {
                catalogNames.add(rs.getString("TABLE_CAT"));
            }
            rs.close();
            return catalogNames;
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    @Override
    public List<String> getDatabasesName() {
        return this.getCatalogsName();
    }

    private ArrayList<ForiegnKeyFieldMeta> getForiegnKeys(String databaseName, String tableName) throws SQLException {
        ResultSet rs = this.getImportedKeys(this.meta, databaseName, tableName);
        ArrayList<ForiegnKeyFieldMeta> fields = new ArrayList<ForiegnKeyFieldMeta>();
        while (rs.next()) {
            ForiegnKeyFieldMeta field = new ForiegnKeyFieldMeta();
            field.setName(rs.getString("FKCOLUMN_NAME"));
            field.setReferenceTable(rs.getString("PKTABLE_NAME"));
            field.setReferenceField(rs.getString("PKCOLUMN_NAME"));
            fields.add(field);
        }
        rs.close();
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdFieldMeta getIdField(String databaseName, String tableName) throws JKDataAccessException, SQLException {
        try (ResultSet rs = this.getPrimaryKeysFromMeta(this.meta, databaseName, tableName);){
            if (rs.next()) {
                IdFieldMeta id = new IdFieldMeta();
                id.setName(rs.getString("COLUMN_NAME"));
                boolean autoIncrement = this.isAutoIncrement(databaseName, tableName);
                id.setAutoIncrement(autoIncrement);
                IdFieldMeta idFieldMeta = id;
                return idFieldMeta;
            }
            IdFieldMeta idFieldMeta = null;
            return idFieldMeta;
        }
    }

    protected ResultSet getImportedKeys(DatabaseMetaData meta, String databaseName, String tableName) throws SQLException {
        return meta.getImportedKeys(databaseName, null, tableName);
    }

    protected ResultSet getPrimaryKeysFromMeta(DatabaseMetaData meta, String databaseName, String tableName) throws SQLException {
        return meta.getPrimaryKeys(databaseName, null, tableName);
    }

    @Override
    public List<String> getSchemas() {
        try {
            ResultSet rs = this.meta.getSchemas();
            ArrayList<String> schemaNames = new ArrayList<String>();
            while (rs.next()) {
                schemaNames.add(rs.getString("TABLE_SCHEM"));
            }
            rs.close();
            return schemaNames;
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    protected TableMeta getTable(String tableName) {
        return this.getTable(this.dataSource.getDatabaseName(), tableName);
    }

    protected TableMeta getTable(String databaseName, String tableName) {
        TableMeta meta = new TableMeta();
        meta.setTableName(tableName);
        this.loadFields(databaseName, meta);
        return meta;
    }

    protected ResultSet getTableColumnsFromMeta(DatabaseMetaData meta, String database, String tableName) throws SQLException {
        return meta.getColumns(database, null, tableName, null);
    }

    public ArrayList<TableMeta> getTablesMeta() {
        return this.getTablesMeta(this.dataSource.getDatabaseName());
    }

    public ArrayList<TableMeta> getTablesMeta(String databaseName) {
        try {
            ResultSet rs = this.loadTableNamesFromMeta(this.meta, databaseName);
            ArrayList<TableMeta> tables = new ArrayList<TableMeta>();
            while (rs.next()) {
                String tableType = rs.getString("TABLE_TYPE");
                if (!tableType.toUpperCase().equals("TABLE")) continue;
                String tableName = rs.getString("TABLE_NAME");
                TableMeta meta = this.getTable(databaseName, tableName);
                tables.add(meta);
            }
            rs.close();
            return tables;
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    protected boolean isAutoIncrement(String databaseName, String tableName) throws JKDataAccessException, SQLException {
        String emptyRowQuery = this.buildEmptyRowQuery(databaseName, tableName);
        CachedRowSet rowSet = this.dao.executeQueryAsCachedRowSet(emptyRowQuery, new Object[0]);
        boolean autoIncrement = rowSet.getMetaData().isAutoIncrement(1);
        return autoIncrement;
    }

    @Override
    public boolean isTableExist(String tableName) {
        List tables = this.getTablesMeta(this.dataSource.getDatabaseName());
        for (TableMeta tableMeta : tables) {
            if (!tableMeta.getTableName().trim().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    protected void loadFields(String database, TableMeta tableMeta) {
        try {
            IdFieldMeta idField = this.getIdField(database, tableMeta.getTableName());
            tableMeta.setIdField(idField);
            ArrayList<ForiegnKeyFieldMeta> foriegnFields = this.getForiegnKeys(database, tableMeta.getTableName());
            for (ForiegnKeyFieldMeta foriegnKeyFieldMeta : foriegnFields) {
                foriegnKeyFieldMeta.setParentTable(tableMeta);
            }
            ResultSet rs = this.getTableColumnsFromMeta(this.meta, database, tableMeta.getTableName());
            while (rs.next()) {
                String fieldName = rs.getString("COLUMN_NAME");
                boolean newField = true;
                FieldMeta fieldMeta = tableMeta.getField(fieldName, true);
                if (fieldMeta != null) {
                    newField = false;
                } else {
                    if (idField == null) {
                        idField = new IdFieldMeta();
                        idField.setAutoIncrement(true);
                        tableMeta.setIdField(idField);
                        fieldMeta = idField;
                        newField = false;
                    } else {
                        fieldMeta = new FieldMeta();
                    }
                    fieldMeta.setName(fieldName);
                    fieldMeta.setParentTable(tableMeta);
                    int index = foriegnFields.indexOf(fieldMeta);
                    if (index != -1) {
                        fieldMeta = foriegnFields.get(index);
                    }
                }
                int type = rs.getInt("DATA_TYPE");
                int nullable = rs.getInt("NULLABLE");
                String defaultValue = rs.getString("COLUMN_DEF");
                int maxLength = rs.getInt("COLUMN_SIZE");
                fieldMeta.setMaxLength(maxLength);
                fieldMeta.setType(type);
                fieldMeta.setRequired(nullable == 0);
                if (defaultValue != null && !defaultValue.equals("null")) {
                    fieldMeta.setDefaultValue(defaultValue);
                }
                if (!newField) continue;
                tableMeta.addField(fieldMeta);
            }
            rs.close();
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }

    protected ResultSet loadTableNamesFromMeta(DatabaseMetaData meta, String dbName) throws SQLException {
        return meta.getTables(dbName, null, null, new String[]{"TABLE"});
    }

    @Override
    public String getDefaultCatalog() {
        try {
            return this.dataSource.getQueryConnection().getCatalog();
        }
        catch (JKDataAccessException | SQLException e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }
}

