/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta;

import com.jk.db.datasource.JKDataSource;
import com.jk.db.dynamic.DynamicDaoFactory;
import com.jk.db.dynamic.meta.generator.DataBaseAnalayzer;
import com.jk.db.dynamic.meta.xml.JKXmlException;
import com.jk.db.dynamic.meta.xml.TableMetaXMLGenerator;
import com.jk.db.dynamic.meta.xml.TableMetaXmlParser;
import com.jk.exceptions.JKDataAccessException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.exceptions.TableMetaNotFoundException;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.util.JKIOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class TableMetaFactory {
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    Hashtable<String, TableMeta> metas = new Hashtable();
    Hashtable<String, TableMeta> dynamicMeta = new Hashtable();
    private final JKDataSource dataSource;

    public TableMetaFactory(JKDataSource connectionManager) {
        this.dataSource = connectionManager;
        try {
            this.loadDynamicMeta(connectionManager);
        }
        catch (Exception e) {
            throw new JKDataAccessException(e);
        }
    }

    public void addTablesMeta(Hashtable<String, TableMeta> newTables) {
        this.logger.debug("addTablesMeta");
        for (String tableMetaName : newTables.keySet()) {
            if (this.metas.get(tableMetaName) == null) continue;
        }
        this.metas.putAll(newTables);
        Collection<TableMeta> values = newTables.values();
        for (TableMeta tableMeta : values) {
            this.dynamicMeta.remove(tableMeta.getTableId());
        }
    }

    public TableMeta getTableMeta(String tableName) {
        this.logger.debug("getTableMeta : " + tableName);
        TableMeta meta = this.metas.get(tableName);
        if (meta == null) {
            this.logger.debug("not found , look into dynamic meta");
            meta = this.dynamicMeta.get(tableName);
            if (meta == null) {
                throw new TableMetaNotFoundException("TableMeta : " + tableName + " doesnot exists");
            }
        }
        this.logger.debug(meta.toString());
        return meta;
    }

    public Hashtable<String, TableMeta> getTables() {
        return this.metas;
    }

    public List<TableMeta> getTablesAsList() {
        Enumeration<String> keys = this.metas.keys();
        ArrayList<TableMeta> list = new ArrayList<TableMeta>();
        while (keys.hasMoreElements()) {
            list.add(this.metas.get(keys.nextElement()));
        }
        return list;
    }

    public boolean isMetaExists(String metaName) {
        return this.metas.get(metaName) != null || this.dynamicMeta.get(metaName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDynamicMeta(JKDataSource dataSource) throws JKDataAccessException, SQLException, FileNotFoundException, IOException, JKXmlException {
        this.logger.debug("loadDynamicMeta");
        if (System.getProperty("tablemeta.dynamic.generate", "true").equals("true")) {
            File file = new File("meta-" + dataSource.getDatabaseName() + ".xml");
            if (file.exists()) {
                this.logger.debug("Dynamic Meta file is already exist , loading from file.");
                TableMetaXmlParser parser = new TableMetaXmlParser();
                this.logger.debug("parsing dynamic meta");
                this.dynamicMeta = parser.parse(new FileInputStream(file), "dynamic");
            } else {
                this.logger.debug("");
                DataBaseAnalayzer analyszer = DynamicDaoFactory.getDatabaseAnalayzer();
                this.logger.debug("Generating table meta : " + file);
                this.dynamicMeta = this.toHashTable(analyszer.getTablesMeta(), "dynamic");
                if (System.getProperty("tablemeta.dynamic.save", "false").equals("true")) {
                    TableMetaXMLGenerator generator = new TableMetaXMLGenerator();
                    String metaXml = generator.generateTablesMetaXml(new ArrayList<TableMeta>(this.dynamicMeta.values()));
                    JKIOUtil.writeDataToFile(metaXml.getBytes(), file);
                    this.logger.debug("Table meta generation done");
                }
            }
        }
    }

    public void loadMetaFiles(InputStream in) throws FileNotFoundException, JKXmlException {
        this.logger.debug("loadMetaFiles");
        TableMetaXmlParser parser = new TableMetaXmlParser();
        Hashtable<String, TableMeta> newTables = parser.parse(in, "user");
        this.addTablesMeta(newTables);
    }

    protected Hashtable<String, TableMeta> toHashTable(List<TableMeta> tablesMeta, String source) {
        Hashtable<String, TableMeta> hash = new Hashtable<String, TableMeta>();
        for (TableMeta tableMeta : tablesMeta) {
            tableMeta.setSource(source);
            hash.put(tableMeta.getTableId(), tableMeta);
        }
        return hash;
    }

    public void writeDynamicMeta(OutputStream out) throws IOException {
        TableMetaXMLGenerator generator = new TableMetaXMLGenerator();
        String xml = generator.generateTablesMetaXml(new ArrayList<TableMeta>(this.dynamicMeta.values()));
        out.write(xml.getBytes());
        out.close();
    }

    public Hashtable<String, TableMeta> getDynamicMeta() {
        return this.dynamicMeta;
    }
}

