/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta;

import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.meta.Field;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.Record;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.metadata.db.query.Keyword;
import com.jk.metadata.db.query.Operator;
import com.jk.metadata.db.query.Query;
import com.jk.metadata.db.query.QueryComponent;
import com.jk.util.JKCollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MetaSqlBuilder {
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    private final TableMeta tableMeta;

    public MetaSqlBuilder(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public String buildDefaultReportSql() {
        if (this.tableMeta.isSingleRecord()) {
            return "SELECT * FROM " + this.tableMeta.getTableName();
        }
        boolean firstField = true;
        StringBuffer buffer = new StringBuffer("SELECT ");
        if (this.tableMeta.getIdField() != null) {
            buffer.append("\n" + this.tableMeta.getIdField().getFullQualifiedName());
            firstField = false;
        }
        Vector<FieldMeta> list = this.tableMeta.getFieldList();
        int foriegnKeyFieldCount = 0;
        for (FieldMeta fieldMeta : list) {
            if (fieldMeta instanceof ForiegnKeyFieldMeta) {
                ForiegnKeyFieldMeta foriegnKeyFieldMeta = (ForiegnKeyFieldMeta)fieldMeta;
                foriegnKeyFieldMeta.setAliasNamePostFix(foriegnKeyFieldCount++);
                String str = this.buildSqlFields(foriegnKeyFieldMeta);
                buffer.append(str);
                continue;
            }
            if (firstField) {
                firstField = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n" + fieldMeta.getFullQualifiedName());
        }
        buffer.append("\n");
        buffer.append("FROM " + this.tableMeta.getTableName());
        ArrayList<ForiegnKeyFieldMeta> foriegnKeyFields = this.tableMeta.lstForiegnKeyFields();
        for (ForiegnKeyFieldMeta foriegnKeyFieldMeta : foriegnKeyFields) {
            buffer.append("\n" + foriegnKeyFieldMeta.getLeftJoinStatement());
        }
        return buffer.toString();
    }

    public String buildDefaultShortSql() {
        Query q = new Query();
        q.addComponent(Keyword.SELECT);
        Vector<FieldMeta> fieldList = this.tableMeta.getFieldList();
        q.addComponent(this.tableMeta.getIdField());
        for (FieldMeta fieldMeta : fieldList) {
            q.addComponent(Operator.COMMA);
            q.addComponent(fieldMeta);
        }
        q.addComponent(Keyword.FROM);
        q.addComponent(this.tableMeta);
        return q.compile();
    }

    public String buildDelete() {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM " + this.tableMeta.getTableName());
        return sql.toString();
    }

    public String buildDelete(Field field) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.buildDelete());
        sql.append(" WHERE " + field.getSqlEquality());
        return sql.toString();
    }

    public String buildFatInsert(List<Record> records) {
        this.logger.debug("buildFatInsert()");
        Query query = new Query();
        query.addComponent(Keyword.INSERT).addComponent(Keyword.INTO).addComponent(this.tableMeta);
        List<QueryComponent> fields = this.getFieldsInInsert(this.tableMeta.createEmptyRecord());
        query.addComponents(fields, Keyword.COMMA, true).addComponent(Keyword.VALUES);
        int i = 0;
        for (Record record : records) {
            IdFieldMeta idField;
            if (i++ > 0) {
                query.addComponent(Keyword.COMMA);
            }
            if ((idField = this.tableMeta.getIdField()).isParticpateInInsert()) {
                query.addValue(record.getIdValue());
            }
            query.addValues(record.getFieldValues(), Keyword.COMMA, true);
        }
        this.logger.debug("Query : ", query);
        return query.compile();
    }

    public String buildFindByFilter(Record filter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT * FROM " + this.tableMeta.getTableName());
        buffer.append("\nWHERE 1=1 ");
        for (int i = 0; i < filter.getFieldsCount(); ++i) {
            Field field = filter.getField(i);
            if (field.getValue() == null) continue;
            buffer.append(" AND " + field.toSqlEquality());
        }
        return buffer.toString();
    }

    public String buildFindById(String id) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT * FROM " + this.tableMeta.getTableName());
        buffer.append("\nWHERE " + this.tableMeta.getIdField().getName() + " = '" + id + "'");
        return buffer.toString();
    }

    public String buildInsert(Record record) {
        Query query = new Query();
        query.addComponent(Keyword.INSERT);
        query.addComponent(Keyword.INTO);
        query.addComponent(this.tableMeta);
        List<QueryComponent> fields = this.getFieldsInInsert(record);
        query.addComponents(fields, Keyword.COMMA, true);
        query.addComponent(Keyword.VALUES);
        query.addComponent(Keyword.VARIABLE, fields.size(), Keyword.COMMA, true);
        return query.compile();
    }

    protected String buildSqlFields(ForiegnKeyFieldMeta fieldMeta) {
        Vector<FieldMeta> summaryFields = fieldMeta.getReferenceTableMeta().lstSummaryFields();
        if (summaryFields.size() == 1) {
            return ",\n" + summaryFields.get(0).getFullQualifiedName(fieldMeta.getAliasNamePostFix());
        }
        StringBuffer buf = new StringBuffer(",CONCAT_WS(' '");
        for (FieldMeta summaryField : summaryFields) {
            buf.append("," + summaryField.getFullQualifiedName(fieldMeta.getAliasNamePostFix()));
        }
        buf.append(") ");
        return buf.toString();
    }

    public String buildUpdate(Record record) {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + this.tableMeta.getTableName() + " \n SET \n ");
        for (int i = 0; i < record.getFieldsCount(); ++i) {
            if (i > 0) {
                sql.append(" , \n ");
            }
            sql.append(this.escapeField(record.getField(i).getMeta().getName()) + "=?");
        }
        sql.append(" \n WHERE " + record.getIdField().getSqlEquality());
        return sql.toString();
    }

    protected String escapeField(String name) {
        String scape = "";
        if (System.getProperty(JKCollectionUtil.fixPropertyKey("DB_ESCAPE_FIELDS"), "true").equals("true")) {
            scape = "`";
        }
        return scape + name + scape;
    }

    protected List<QueryComponent> getFieldsInInsert(Record record) {
        ArrayList<QueryComponent> fields = new ArrayList<QueryComponent>();
        IdFieldMeta idField = this.tableMeta.getIdField();
        if (record.getIdValue() != null) {
            fields.add(idField);
        }
        fields.addAll(this.tableMeta.getFieldList());
        return fields;
    }
}

