/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic.meta;

import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.db.dynamic.meta.TableMetaFactory;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.exceptions.TableMetaNotFoundException;
import com.jk.metadata.db.meta.TableMeta;
import java.util.Enumeration;
import java.util.Hashtable;

public class AbstractTableMetaFactory {
    static JKLogger logger = JKLoggerFactory.getLogger(AbstractTableMetaFactory.class);
    static Hashtable<JKDataSource, TableMetaFactory> metaFactorys = new Hashtable();
    static JKDataSource defaultConnectionManager = JKDataSourceFactory.getDefaultDataSource();

    public static TableMetaFactory addTablesMeta(JKDataSource connectionManager, Hashtable<String, TableMeta> newTables) {
        logger.debug("addTablesMeta: " + newTables);
        TableMetaFactory metaFactory = AbstractTableMetaFactory.getMetaFactory(connectionManager);
        metaFactory.addTablesMeta(newTables);
        return metaFactory;
    }

    public static TableMetaFactory getDefaultMetaFactory() {
        return metaFactorys.get(defaultConnectionManager);
    }

    public static TableMetaFactory getMetaFactory(JKDataSource connectionManager) {
        TableMetaFactory metaFactory = metaFactorys.get(connectionManager);
        if (metaFactory == null) {
            metaFactory = new TableMetaFactory(connectionManager);
            metaFactorys.put(connectionManager, metaFactory);
        }
        return metaFactory;
    }

    public static TableMeta getTableMeta(JKDataSource connectionManager, String metaName) {
        logger.debug("getTableMeta :" + metaName);
        return metaFactorys.get(connectionManager).getTableMeta(metaName);
    }

    public static TableMeta getTableMeta(String tableName) {
        logger.debug("getTableMeta : " + tableName);
        TableMetaFactory defaultMetaFactory = AbstractTableMetaFactory.getDefaultMetaFactory();
        if (defaultMetaFactory.isMetaExists(tableName)) {
            logger.debug("get from default datasource");
            return defaultMetaFactory.getTableMeta(tableName);
        }
        logger.debug("not found inside default datasource , look into other connections");
        Enumeration<JKDataSource> keys = metaFactorys.keys();
        while (keys.hasMoreElements()) {
            TableMetaFactory tableMetaFactory = metaFactorys.get(keys.nextElement());
            if (defaultMetaFactory == tableMetaFactory || !tableMetaFactory.isMetaExists(tableName)) continue;
            return tableMetaFactory.getTableMeta(tableName);
        }
        throw new TableMetaNotFoundException("TableMeta : " + tableName + " doesnot exists");
    }

    public static void registerFactory(JKDataSource manager, TableMetaFactory factory) {
        metaFactorys.put(manager, factory);
    }

    static {
        TableMetaFactory defaultFactory = new TableMetaFactory(defaultConnectionManager);
        metaFactorys.put(defaultConnectionManager, defaultFactory);
    }
}

