/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic;

import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.db.dynamic.DynamicDao;
import com.jk.db.dynamic.meta.AbstractTableMetaFactory;
import com.jk.db.dynamic.meta.generator.DataBaseAnalayzer;
import com.jk.db.dynamic.meta.generator.DefaultDatabaseAnalazyer;
import com.jk.db.dynamic.mysql.MySqlDatabaseAnalayzer;
import com.jk.db.dynamic.oracle.OracleDatabaseAnalayzer;
import com.jk.db.dynamic.oracle.OracleDynamicDao;
import com.jk.metadata.db.meta.TableMeta;

public class DynamicDaoFactory {
    public static DynamicDao createDynamicDao(String tableMetaName) {
        return DynamicDaoFactory.createDynamicDao(AbstractTableMetaFactory.getTableMeta(tableMetaName));
    }

    public static DynamicDao createDynamicDao(TableMeta tableMeta) {
        JKDataSource dataSource = JKDataSourceFactory.getDefaultDataSource();
        switch (dataSource.getDatabaseType()) {
            case ORACLE: {
                return new OracleDynamicDao(tableMeta);
            }
        }
        return new DynamicDao(tableMeta);
    }

    public static DataBaseAnalayzer getDatabaseAnalayzer() {
        JKDataSource dataSource = JKDataSourceFactory.getDefaultDataSource();
        return DynamicDaoFactory.getDatabaseAnalayzer(dataSource);
    }

    public static DataBaseAnalayzer getDatabaseAnalayzer(JKDataSource dataSource) {
        switch (dataSource.getDatabaseType()) {
            case ORACLE: {
                return new OracleDatabaseAnalayzer(dataSource);
            }
            case MYSQL: {
                return new MySqlDatabaseAnalayzer(dataSource);
            }
        }
        return new DefaultDatabaseAnalazyer(dataSource);
    }
}

