/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dynamic;

import com.jk.db.dataaccess.exception.JKRecordNotFoundException;
import com.jk.db.dataaccess.plain.JKAbstractPlainDataAccess;
import com.jk.db.dataaccess.plain.JKFinder;
import com.jk.db.dataaccess.plain.JKUpdater;
import com.jk.db.datasource.JKSession;
import com.jk.db.dynamic.DynamicDaoFactory;
import com.jk.db.dynamic.meta.AbstractTableMetaFactory;
import com.jk.db.dynamic.meta.MetaSqlBuilder;
import com.jk.db.util.JdbcUtil;
import com.jk.exceptions.JKDataAccessException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.meta.Field;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.Record;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.metadata.db.trigger.Trigger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DynamicDao
extends JKAbstractPlainDataAccess {
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    protected final TableMeta tableMeta;
    protected MetaSqlBuilder sqlBuilder;

    public DynamicDao(String tableMetaName) {
        this(AbstractTableMetaFactory.getTableMeta(tableMetaName));
        this.logger.debug(tableMetaName);
    }

    public DynamicDao(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
        this.sqlBuilder = new MetaSqlBuilder(tableMeta);
    }

    protected void callAfterAddEventOnTriggers(Record record) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).afterAdd(record);
        }
    }

    protected void callAfterDeleteEventOnTriggers(Record record) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).afterDelete(record);
        }
    }

    protected void callAfterFindEventOnTriggers(Record record) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).afterFind(record);
        }
    }

    protected void callAfterUpdateEventOnTriggers(Record oldRecord, Record newRecord) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).afterUpdate(oldRecord, newRecord);
        }
    }

    protected void callBeforeAddEventOnTriggers(Record record) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).beforeAdd(record);
        }
    }

    protected void callBeforeDeleteEventOnTriggers(Record record) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).beforeDelete(record);
        }
    }

    protected void callBeforeUpdateEventOnTriggers(Record oldRecord, Record newRecord) {
        ArrayList<Trigger> triggers = this.tableMeta.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).beforeUpdate(oldRecord, newRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneDetails(Object sourceIdValue, Object targetIdValue) {
        ArrayList<ForiegnKeyFieldMeta> detailFields = this.tableMeta.getDetailFields();
        JKSession session = this.getDataSource().createSession();
        boolean commit = false;
        try {
            for (ForiegnKeyFieldMeta foriegnKeyFieldMeta : detailFields) {
                DynamicDao detailDao = DynamicDaoFactory.createDynamicDao(foriegnKeyFieldMeta.getParentTable());
                List<Record> detailRecords = detailDao.findByFieldValue(foriegnKeyFieldMeta.getName(), sourceIdValue);
                for (Record detailRecord : detailRecords) {
                    detailRecord.setIdValue(null);
                    detailRecord.setFieldValue(foriegnKeyFieldMeta.getName(), targetIdValue);
                    detailDao.insertRecord(detailRecord);
                }
            }
            commit = true;
        }
        finally {
            session.close(commit);
        }
    }

    public Record createEmptyRecord() {
        return this.createEmptyRecord(true);
    }

    public Record createEmptyRecord(boolean setDefaultValues) {
        return this.tableMeta.createEmptyRecord(setDefaultValues);
    }

    public Record createEmptyRecord(boolean setDefaultValues, Record defaults) {
        return this.tableMeta.createEmptyRecord(setDefaultValues, defaults);
    }

    public void deleteAllRecords() {
        this.logger.debug("deleteAllRecords for tablemeta : ", this.tableMeta);
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildDelete();
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        this.executeUpdate(updater);
    }

    public void deleteByFieldsValues(HashMap<String, String> fieldNameToValue) {
        this.logger.debug(fieldNameToValue.toString());
        Record filterRecord = this.tableMeta.createEmptyRecord();
        Set<String> keySet = fieldNameToValue.keySet();
        for (String fieldName : keySet) {
            filterRecord.setFieldValue(fieldName, fieldNameToValue.get(fieldName));
        }
        List<Record> lstRecords = this.lstRecords(filterRecord);
        for (Record record : lstRecords) {
            this.deleteRecord(record);
        }
    }

    public void deleteByFieldValue(String fieldName, Object value) {
        this.logger.debug(fieldName, " = ", value);
        Record record = this.createEmptyRecord(false);
        record.setFieldValue(fieldName, value);
        this.deleteRecord(record.getField(fieldName), false);
    }

    public void deleteRecord(Field field) {
        this.logger.debug(field.toString());
        this.deleteRecord(field, true);
    }

    public void deleteRecord(final Field field, boolean addAudit) {
        this.logger.debug(field, " , add audit : ", addAudit);
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildDelete(field);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        Record record = null;
        if (addAudit) {
            record = this.findRecord(field.getValueAsInteger());
        }
        this.executeUpdate(updater);
    }

    public void deleteRecord(Object recordId) {
        Record record = this.createEmptyRecord(false);
        record.setIdValue(recordId);
        this.deleteRecord(record);
    }

    public void deleteRecord(Record record) {
        this.callBeforeDeleteEventOnTriggers(record);
        this.deleteRecord(record.getIdField());
        this.callAfterDeleteEventOnTriggers(record);
    }

    public void deleteRecords(Record filter) {
        List<Record> findRecord = this.lstRecords(filter);
        for (Record record : findRecord) {
            this.deleteRecord(record);
        }
    }

    public void executeUpdateQuery(final String sql, final Object[] objects) {
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return sql;
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < objects.length; ++i) {
                    ps.setObject(i + 1, objects[i]);
                }
            }
        };
        this.executeUpdate(updater);
    }

    public List<Record> findByFieldValue(String fieldName, Object value) {
        Record filterRecord = this.tableMeta.createEmptyRecord();
        filterRecord.setFieldValue(fieldName, value);
        return this.lstRecords(filterRecord);
    }

    public Record findRecord(final Object id) {
        JKFinder finder = new JKFinder(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildFindById(id.toString());
            }

            public Object populate(ResultSet rs) throws SQLException {
                return DynamicDao.this.readRecord(rs, DynamicDao.this.tableMeta);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        Record record = (Record)this.findRecord(finder);
        this.callAfterFindEventOnTriggers(record);
        return record;
    }

    public Record findRecord(final Record filter) {
        JKFinder finder = new JKFinder(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildFindByFilter(filter);
            }

            public Object populate(ResultSet rs) throws SQLException, JKRecordNotFoundException, JKDataAccessException {
                return DynamicDao.this.readRecord(rs, DynamicDao.this.tableMeta);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        return (Record)this.findRecord(finder);
    }

    public Record findRecordByFieldValue(HashMap<String, String> fieldNameToValue) {
        Record filterRecord = this.tableMeta.createEmptyRecord();
        for (String fieldName : fieldNameToValue.keySet()) {
            filterRecord.setFieldValue(fieldName, fieldNameToValue.get(fieldName));
        }
        return this.findRecord(filterRecord);
    }

    public Record findRecordByFieldValue(String fieldName, Object value) {
        Record filterRecord = this.tableMeta.createEmptyRecord();
        filterRecord.setFieldValue(fieldName, value);
        return this.findRecord(filterRecord);
    }

    public String getAssignedValuesQuery(int field1Id) {
        StringBuffer buf = new StringBuffer();
        ArrayList<ForiegnKeyFieldMeta> list = this.tableMeta.lstForiegnKeyFields();
        ForiegnKeyFieldMeta field1 = list.get(0);
        ForiegnKeyFieldMeta field2 = list.get(1);
        TableMeta refTable = AbstractTableMetaFactory.getTableMeta(field2.getReferenceTable());
        String sql = refTable.getShortReportSql();
        sql = sql + (sql.toUpperCase().contains("WHERE") ? " AND " : " WHERE ");
        buf.append(sql);
        buf.append(field2.getReferenceField() + " IN (");
        buf.append(" SELECT " + field2.getName() + " FROM " + field2.getParentTable().getTableName());
        buf.append(" WHERE " + field1.getName() + " = " + field1Id);
        buf.append(")");
        return buf.toString();
    }

    public Record getFirstRecordInTable() {
        this.logger.debug("First record");
        List<Record> r = this.lstRecords();
        if (r.size() > 0) {
            return r.get(0);
        }
        return null;
    }

    public String getNotAssignedValuesQuery(int field1Id) {
        StringBuffer buf = new StringBuffer();
        ArrayList<ForiegnKeyFieldMeta> list = this.tableMeta.lstForiegnKeyFields();
        ForiegnKeyFieldMeta field1 = list.get(0);
        ForiegnKeyFieldMeta field2 = list.get(1);
        TableMeta refTable = AbstractTableMetaFactory.getTableMeta(field2.getReferenceTable());
        String sql = refTable.getShortReportSql();
        sql = sql + (sql.toUpperCase().contains("WHERE") ? " AND " : " WHERE ");
        buf.append(sql);
        buf.append(field2.getReferenceField() + " NOT IN (");
        buf.append(" SELECT " + field2.getName() + " FROM " + field2.getParentTable().getTableName());
        buf.append(" WHERE " + field1.getName() + " = " + field1Id);
        buf.append(")");
        return buf.toString();
    }

    public MetaSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public String insertRecord(final Record record) {
        this.callBeforeAddEventOnTriggers(record);
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildInsert(record);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
                DynamicDao.this.setParamters(record, ps, true);
            }
        };
        String id = this.executeUpdate(updater) + "";
        record.setIdValue(id);
        record.setNewRecord(false);
        this.callAfterAddEventOnTriggers(record);
        return id;
    }

    public void insertRecords(List<Record> records) {
        if (records.size() > 0) {
            String insert = this.sqlBuilder.buildFatInsert(records);
            this.execute(insert, new Object[0]);
        }
    }

    public boolean isIdExists(Object id) {
        try {
            this.findRecord(id.toString());
            return true;
        }
        catch (JKRecordNotFoundException e) {
            return false;
        }
        catch (JKDataAccessException e) {
            throw e;
        }
    }

    public List<Record> lstRecords() {
        this.logger.debug("lstRecords : ", this.tableMeta.getTableName());
        return this.lstRecords(this.createEmptyRecord(false));
    }

    public List<Record> lstRecords(final Record filter) {
        this.logger.debug(filter.toString());
        JKFinder finder = new JKFinder(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildFindByFilter(filter);
            }

            public Object populate(ResultSet rs) throws SQLException {
                return DynamicDao.this.readRecord(rs, DynamicDao.this.tableMeta);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        return this.getList(finder);
    }

    public List<Record> lstRecordsByReportSql() {
        JKFinder daoFinder = new JKFinder(){

            @Override
            public String getQuery() {
                return DynamicDao.this.tableMeta.getReportSql();
            }

            public Object populate(ResultSet rs) throws SQLException, JKRecordNotFoundException, JKDataAccessException {
                return DynamicDao.this.readRecord(rs, DynamicDao.this.tableMeta);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        return this.getList(daoFinder);
    }

    public boolean saveRecord(Record record) {
        this.logger.debug("saveRecord() :", record.toString(true));
        if (record.isNewRecord() && record.isModified()) {
            this.logger.debug("insert()");
            this.insertRecord(record);
            return true;
        }
        if (!record.isNewRecord() && record.isDeleted()) {
            this.logger.debug("deleteRecord()");
            this.deleteRecord(record);
            return true;
        }
        if (record.isModified()) {
            this.logger.debug("updateRecord()");
            this.updateRecord(record);
            return true;
        }
        this.logger.error("No operation to dine");
        return false;
    }

    public void saveRecords(List<Record> records) {
        JKDataAccessException allExceptions = new JKDataAccessException();
        for (Record record : records) {
            try {
                this.saveRecord(record);
            }
            catch (JKDataAccessException e) {
                allExceptions.add(e);
            }
        }
    }

    public void updateRecord(final Record record) {
        JKUpdater updater = new JKUpdater(){

            @Override
            public String getQuery() {
                return DynamicDao.this.sqlBuilder.buildUpdate(record);
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
                DynamicDao.this.setParamters(record, ps, false);
            }
        };
        Record oldRecord = this.findRecord(record.getIdValue());
        this.callBeforeUpdateEventOnTriggers(oldRecord, record);
        this.executeUpdate(updater);
        this.callAfterUpdateEventOnTriggers(oldRecord, record);
    }

    protected Record readRecord(ResultSet rs, TableMeta tableMeta) throws SQLException {
        Record record = tableMeta.createEmptyRecord();
        record.setIdValue(rs.getObject(tableMeta.getIdField().getName()));
        ArrayList<Field> fields = record.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            Object value = this.readResult(rs, field);
            if (value == null) continue;
            field.setValue(value);
        }
        record.setNewRecord(false);
        return record;
    }

    protected Object readResult(ResultSet rs, Field field) throws SQLException {
        switch (field.getMeta().getType()) {
            case -6: 
            case 16: {
                return rs.getInt(field.getMeta().getName()) == 1;
            }
            case 2: 
            case 4: 
            case 12: {
                return rs.getString(field.getMeta().getName());
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return JdbcUtil.getBinaryStream(rs, field.getMeta().getName());
            }
            case 91: {
                return rs.getDate(field.getMeta().getName());
            }
            case 92: {
                return rs.getTime(field.getMeta().getName());
            }
        }
        return rs.getObject(field.getMeta().getName());
    }

    protected void setParamter(PreparedStatement ps, int index, Field field) throws SQLException {
        Object value = field.getValueObject();
        if (value == null || value.toString().equals("")) {
            ps.setObject(index, null);
            return;
        }
        switch (field.getMeta().getType()) {
            case -4: 
            case -2: {
                byte[] data = (byte[])field.getValueObject();
                ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(data), data.length);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                ps.setInt(index, field.getValueAsBoolean() != false ? 1 : 0);
                break;
            }
            case 3: {
                ps.setDouble(index, field.getValueAsDouble());
                break;
            }
            case 91: {
                ps.setDate(index, new Date(((java.util.Date)field.getValueObject()).getTime()));
                break;
            }
            case 92: {
                ps.setTime(index, new Time(((java.util.Date)field.getValueObject()).getTime()));
                break;
            }
            case -1: 
            case 12: {
                ps.setString(index, field.getValueObject().toString());
            }
            default: {
                ps.setObject(index, value);
            }
        }
    }

    protected void setParamters(Record record, PreparedStatement ps, boolean includeId) throws SQLException {
        int counter = 1;
        if (includeId && record.getIdValue() != null) {
            this.setParamter(ps, counter++, record.getIdField());
        }
        ArrayList<Field> fields = record.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            try {
                this.setParamter(ps, counter++, fields.get(i));
                continue;
            }
            catch (Exception e) {
                FieldMeta meta = fields.get(i).getMeta();
                throw new SQLException("Field " + meta.getName() + " Failed to set paramter with value :" + fields.get(i).getValueObject() + "  with type  :" + meta.getType(), e);
            }
        }
    }
}

